<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        step4.jsp
  -- Controller:  db/adm/util/AnalyzeController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="schmMsgs"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="WIZARD@uixAnalyzeBundle@servletRequest"/>
</uix:metaContainer>

<%--
<%@ include file="/oemTitle.jspf" %>
--%>

<uix:body>
 <uix:contents>  

               <db:form name="scheduleForm" method="POST" destination="/console/database/util/analyze" copyParams="target,type">

                     <uix:formValue name="pageName" value="/database/util/analyze/step4"/>
             <uix:pageLayout titleBinding="STEP4_HEADER@uixAnalyzeBundle@servletRequest">

 
    

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <uix:location> 
  <uix:train selectedIndex="3">
                           <uix:contents>
                              <uix:styledText textBinding="STEP1@uixAnalyzeBundle@servletRequest"/>
                              <uix:styledText textBinding="STEP2@uixAnalyzeBundle@servletRequest"/>
                              <uix:styledText textBinding="STEP3@uixAnalyzeBundle@servletRequest"/>
                              <uix:styledText textBinding="STEP4@uixAnalyzeBundle@servletRequest"/>
                              <uix:styledText textBinding="STEP5@uixAnalyzeBundle@servletRequest"/>
                           </uix:contents>
                        </uix:train>
  </uix:location>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
 
      
 

           <uix:rowLayout>
              <uix:contents>
                 <uix:styledText styleClass="OraInstructionText" textBinding="STEP4_INTRO1@uixAnalyzeBundle@servletRequest"/>
              </uix:contents>
           </uix:rowLayout>
           <uix:spacer height="5"/>

          
              <uix:labeledFieldLayout labelWidth="26%">
                <uix:contents>
                  <uix:messagePrompt required="yes" promptBinding="STEP4_TASK_ID@uixAnalyzeBundle@servletRequest" labeledNodeId="taskID"/>
                  <uix:textInput id="taskID" name="taskID" textBinding="taskID@objectBean@servletRequest" readOnly="false" maximumLength="50" columns="50"/>
                  <uix:messagePrompt promptBinding="JOB_DESC@schmMsgs" labeledNodeId="jobDescription"/>
                  <uix:textInput id="jobDescription" name="taskDesc" textBinding="taskDesc@objectBean@servletRequest" maximumLength="50" columns="50"/>
                </uix:contents>
              </uix:labeledFieldLayout>
            <%--
              </uix:rowLayout>
            </uix:tableLayout> --%>
                              
            <uix:spacer height="10"/>

             <uix:switcher childNameBinding="ifVersion10OrHigher@objectBean@servletRequest">
                <uix:case name="false">
                  <uix:header textBinding="STEP4_HOST_CREDENTIALS@uixAnalyzeBundle@servletRequest" size="2">
                    <uix:rowLayout>
                       <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" textBinding="STEP4_INTRO2@uixAnalyzeBundle@servletRequest"/>
                       </uix:contents>
                    </uix:rowLayout>
                    <uix:spacer height="5"/>
                    <%@ include file="/credentials.jspf"%>
                  </uix:header>
              </uix:case>
            </uix:switcher>
          
           <uix:spacer height="10"/>

            <uix:header textBinding="STEP4_SCHEDULE@uixAnalyzeBundle@servletRequest" size="2">
               <%@ include file="/sdk/schedule/schedule.jspf" %>     
           </uix:header>

          <%-- start buttons section --%>
               <uix:pageButtons>
                  <uix:pageButtonBar>
                     <uix:contents>
                        <uix:button name="done" destinationBinding="homePage@objectBean@servletRequest" textBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                        <uix:spacer width="5"/>      
                          <uix:navigationBar destination="/console/database/util/analyze" formName="scheduleForm" formSubmitted="true" maxValue="5" minValue="1" name="analyzeNavigationBar" value="4"/>
                     </uix:contents>
                  </uix:pageButtonBar>
               </uix:pageButtons>
          <%-- end buttons section --%>
  </uix:pageLayout>
</db:form>
</uix:contents>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
