<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/LOV.js"/>
    <db:script src="/database/dbclone/remoteSelector.js"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:bundle name="asmConfMsgs" class="oracle.sysman.db.rsc.config.ASMConfigMsg"/>
    <uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
    <uix:bundle name="testDBMsgs" class="oracle.sysman.db.rsc.rec.TestDBMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        function setLovName(name)
        {
            document.forms[0].lovName.value = name;
        }
        </script>

            <uix:body>
            <db:form name="asmConfGeneral" method="post" destination="/console/database/asmconf" copyParams="target,type">
                <uix:formValue name="pageName" value="/database/util/config/asmConfSettings"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="lovName"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="warning" 
                    errorTableBinding="warnings@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                        <uix:contents>
                            <uix:labeledFieldLayout width="60%">
                                <uix:contents>
                                    <uix:messageStyledText renderedBinding="nonClusterTarget@defaultBean@servletRequest" promptBinding="HOST@asmConfMsgs" textBinding="host@defaultBean@servletRequest" styleClass="OraDataText"/>  
                                    <uix:messageStyledText renderedBinding="clusterTarget@defaultBean@servletRequest" promptBinding="CLUSTER@asmConfMsgs" textBinding="host@defaultBean@servletRequest" styleClass="OraDataText"/>
                                    <uix:messageStyledText promptBinding="ORACLE_HOME@asmConfMsgs" textBinding="asmHome@defaultBean@servletRequest" styleClass="OraDataText"/>
                                </uix:contents>
                            </uix:labeledFieldLayout>
                            <uix:separator/>
                            <uix:header textBinding="MEMBER_NODES@asmConfMsgs" renderedBinding="crsHome@defaultBean@servletRequest">
                                <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="MEMBER_NODES_INSTR@asmConfMsgs"/>
                                    <uix:labeledFieldLayout  width="60%">
                                        <uix:contents>
                                            <uix:messageList name="nodeListForUI" multiple="true">
                                                <uix:contents childDataBinding="nodeListForUI@defaultBean@servletRequest">
                                                    <uix:option textBinding="nodeName" valueBinding="nodeName"/>
                                                </uix:contents>
                                            </uix:messageList>
                                            
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                </uix:contents>
                            </uix:header>
                            <uix:header textBinding="ASMSNMP_CREDS@asmConfMsgs" renderedBinding="version112AndAbove@defaultBean@servletRequest" >
                                <uix:contents>
                                    
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="ASMSNMP_CREDS_INSTR@asmConfMsgs"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:labeledFieldLayout>
                                        <uix:contents>
                                            <uix:messageTextInput columns="30" name="asmsnmpPassword" promptBinding="PASSWORD@asmConfMsgs" required="uiOnly" noAutoComplete="true" secret="true" textBinding="asmsnmpPassword@defaultBean@servletRequest"/>
                                            <uix:messageTextInput columns="30" name="asmsnmpConfirmPassword" promptBinding="CONFIRM_PASSWORD@asmConfMsgs" noAutoComplete="true" secret="true" required="uiOnly" textBinding="asmsnmpConfirmPassword@defaultBean@servletRequest"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                    
                                </uix:contents>
                            </uix:header> 
                         <uix:header textBinding="INIT_PARAMS@asmConfMsgs">
                          <uix:contents>
                            <uix:messageStyledText styleClass="OraInstructionText" textBinding="INIT_PARAMS_INSTR@asmConfMsgs"/>
                            <uix:spacer height="10" width="10"/>
                            <uix:tableLayout cellSpacing="5" width="100%">

              
                <uix:rowLayout width="100%">


                  <uix:cellFormat hAlign="right" width="20%" vAlign="top">
                    <uix:messagePrompt labeledNodeId="diskDiscoveryPath" 
                      promptBinding="DISK_DISCOVERY_PATH@asmConfMsgs"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                        <uix:messageTextInput id="diskDiscoveryPath" 
                          name="diskDiscoveryPath"
                          textBinding="diskDiscoveryPath@defaultBean@servletRequest"
			  shortDescBinding="DISK_DISCOVERY_PATH@asmConfMsgs"
			  tipBinding="DISK_DISCOVERY_PATH_TIP@asmConfMsgs" 
                          columns="30"/>
                  </uix:cellFormat>

                </uix:rowLayout>
		<uix:rowLayout width="100%">


                  <uix:cellFormat hAlign="right" width="20%" vAlign="top">
                    <uix:messagePrompt labeledNodeId="diagnosticDest" 
                      promptBinding="DIAG_DEST@asmConfMsgs"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                        <uix:messageLovField id="diagnosticDest" 
                          name="diagnosticDest"
                          textBinding="diagnosticDest@defaultBean@servletRequest"
                          searchDescBinding="DIAG_DEST@asmConfMsgs"
                          shortDescBinding="DIAG_DEST@asmConfMsgs"
                          columns="30"
			  tipBinding="DIAG_AUD_FILE_LOC_TIP@testDBMsgs"
                          onClick="setLovName(document.forms[0].diagnosticDest.name);openWindow(window, '/em/console/page/rfs/postBackWithEvent', 'lovWindow', {width:750, height:550}, true, 'dialog', '');"/>
                  </uix:cellFormat>

                </uix:rowLayout>
</uix:tableLayout>

                            
                           <uix:hideShowHeader textBinding="ADVANCED@asmConfMsgs" id="initParams"    disclosedBinding="initParamsState@servletRequest" formSubmitted="true" partialRenderMode="self">
                              <uix:contents>
                                  <uix:spacer height="10" width="10"/>
                                <uix:labeledFieldLayout width="70%">
                                  <uix:contents>
                                    <uix:messageTextInput columns="30" renderedBinding="version11AndAbove@defaultBean@servletRequest" name="memoryTarget" shortDescBinding="MEMORY_TARGET@asmConfMsgs" promptBinding="MEMORY_TARGET@asmConfMsgs" textBinding="memoryTarget@defaultBean@servletRequest"/>
                                    <uix:messageTextInput columns="30" name="sharedPoolSize" shortDescBinding="SHARED_POOL_SIZE@asmConfMsgs" promptBinding="SHARED_POOL_SIZE@asmConfMsgs" textBinding="sharedPoolSize@defaultBean@servletRequest"/>
                                    <uix:messageTextInput columns="30" name="largePoolSize" shortDescBinding="LARGE_POOL_SIZE@asmConfMsgs" promptBinding="LARGE_POOL_SIZE@asmConfMsgs" textBinding="largePoolSize@defaultBean@servletRequest"/>
                                  </uix:contents>
                                </uix:labeledFieldLayout>
                              </uix:contents>
                            </uix:hideShowHeader>
                          </uix:contents>
                        </uix:header>
                        
                        <uix:header textBinding="DISK_GROUPS@asmConfMsgs">
                          <uix:contents>
                           <uix:spacer height="10" width="10"/>
                              <uix:tableLayout hAlign="left" width="100%">
                                  <uix:contents>
                                      <uix:rowLayout width="100%">
                                          <uix:contents>
                                              <uix:cellFormat hAlign="right">
                                                  <uix:contents>
                                                      <uix:button shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" onClick="submitForm('asmConfGeneral', true, {event:'createDg'})"/>
                                                  </uix:contents>
                                              </uix:cellFormat>
                                          </uix:contents>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                          <uix:contents>
                                              <uix:dataScope currentDataBinding="DISK_GROUPS_LIST@servletRequest">
                                                  <uix:table name="DISK_GROUPS_LIST" 
                                                             alternateTextBinding="diskGroupsAlterText"
                                                             formSubmitted="true"
                                                             width="100%"
                                                             tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                             minValue="1"
                                                             valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                             blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                             maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                             summaryBinding="diskGroupsSummary">
                                                      
                                                      
                                                      <uix:tableFormat tableBanding="rowBanding"/>
                                                      <uix:column>
                                                          <uix:columnHeader>
                                                              <uix:sortableHeader textBinding="DG_NAME@asmConfMsgs"/>
                                                          </uix:columnHeader> 
                                                          <uix:columnFormat columnDataFormat="textFormat" width="40%"/>
                                                          <uix:messageStyledText textBinding="dgName" />
                                                      </uix:column>
                                                      <uix:column>
                                                          <uix:columnHeader>
                                                              <uix:sortableHeader  textBinding="NUM_OF_DISKS@asmConfMsgs"/>
                                                          </uix:columnHeader> 
                                                          <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                                          <uix:messageStyledText textBinding="numOfDisks" />
                                                      </uix:column>
                                                      <uix:column>
                                                          <uix:columnHeader>
                                                              <uix:sortableHeader  textBinding="REDUNDANCY@asmConfMsgs"/>
                                                          </uix:columnHeader> 
                                                          <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                                          <uix:messageStyledText textBinding="redundancy" />
                                                      </uix:column>
                                                      <uix:tableSelection>
                                                      <uix:singleSelection shortDescBinding="DISK_GROUPS@asmConfMsgs" selectedIndex="0">
                                                          <uix:contents>
                                                              <uix:submitButton textBinding="CONFIGURE@asmConfMsgs" shortDescBinding="CONFIGURE@asmConfMsgs" name="event" value="configureDg"/> 
                                                              <uix:submitButton textBinding="REMOVE@asmConfMsgs" shortDescBinding="REMOVE@asmConfMsgs" name="event" value="deleteDg"/> 
                                                              <uix:submitButton textBinding="USE_STORE_SPFILE@asmConfMsgs" shortDescBinding="USE_STORE_SPFILE@asmConfMsgs" name="event" value="dgForSPFile"/>   
                                                          </uix:contents>
                                                      </uix:singleSelection>
                                                      </uix:tableSelection>
                                                  </uix:table>
                                              </uix:dataScope>
                                          </uix:contents>
                                      </uix:rowLayout>
                                      
                                  </uix:contents>
                              </uix:tableLayout> 
                          </uix:contents>
                        </uix:header>
                            <uix:header renderedBinding="version112AndAbove@defaultBean@servletRequest" textBinding="SPFILE_LOC@asmConfMsgs">
                                <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="SPFILE_LOC_INSTR@asmConfMsgs"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:labeledFieldLayout width="70%">
                                        <uix:contents>
                                            <uix:messageStyledText styleClass="OraDataText" promptBinding="DISKGROUP@asmConfMsgs" textBinding="dgForSpfileForDisplay@defaultBean@servletRequest"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                </uix:contents>
                            </uix:header>
                            <uix:header renderedBinding="versionBelow112@defaultBean@servletRequest" textBinding="LISTENER_CONFIG@asmConfMsgs">
                                <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="LISTENER_CONFIG_INSTR@asmConfMsgs"/>
                                    <uix:spacer height="10" width="10"/>
                                    <%@ include file="listenersLov.jspf"%>
                                </uix:contents>
                            </uix:header>
                            <uix:header renderedBinding="version112AndAbove@defaultBean@servletRequest" textBinding="LISTENER_CONFIG@asmConfMsgs">
                                <uix:contents>
                                    <uix:messageStyledText styleClass="OraInstructionText" textBinding="DEF_LISTENER_INSTR@asmConfMsgs"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:labeledFieldLayout width="70%">
                                        <uix:contents>
                                            <uix:messageStyledText styleClass="OraDataText" promptBinding="DEF_LSNR_PORT@asmConfMsgs" textBinding="defaultListenerPort@defaultBean@servletRequest"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                </uix:contents>
                            </uix:header>
                        </uix:contents>
                                                
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="3" formSubmitted="true" value="2"/>
                                
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                     <uix:location>
                        <uix:train formSubmitted="true" value="2">
                          
                          <uix:contents>
                           <uix:link shortDescBinding="SELECT_DESTINATION@asmConfMsgs" textBinding="SELECT_DESTINATION@asmConfMsgs"/>
                            <uix:link shortDescBinding="CONF_SETTINGS@asmConfMsgs" textBinding="CONF_SETTINGS@asmConfMsgs"/>
                            <uix:link shortDescBinding="REVIEW@asmConfMsgs" textBinding="REVIEW@asmConfMsgs"/>
                            
                          </uix:contents>
                        
                        </uix:train>
                      </uix:location>   
                    </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
                        
