<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/> 
    <uix:bundle name="asmConfMsgs" class="oracle.sysman.db.rsc.config.ASMConfigMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>

        

            <uix:body>
            <db:form name="selectDest" method="post" destination="/console/database/asmconf" copyParams="target,type,">
                <uix:formValue name="pageName" value="/database/util/config/asmReview"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="warning" 
                    errorTableBinding="warnings@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        
                        <uix:labeledFieldLayout width="60%">
                            <uix:contents>
                                <uix:messageStyledText renderedBinding="nonClusterTarget@defaultBean@servletRequest" promptBinding="HOST@asmConfMsgs" textBinding="host@defaultBean@servletRequest" styleClass="OraDataText"/>  
                                <uix:messageStyledText renderedBinding="clusterTarget@defaultBean@servletRequest" promptBinding="CLUSTER@asmConfMsgs" textBinding="host@defaultBean@servletRequest" styleClass="OraDataText"/>
                                <uix:messageStyledText promptBinding="ORACLE_HOME@asmConfMsgs" textBinding="asmHome@defaultBean@servletRequest" styleClass="OraDataText"/>
                            </uix:contents>
                        </uix:labeledFieldLayout>
                        <uix:separator/>
                        <uix:header textBinding="MEMBER_NODES@asmConfMsgs" renderedBinding="crsHome@defaultBean@servletRequest">
                            <uix:contents>
                                
                                <uix:labeledFieldLayout  width="60%">
                                    <uix:contents>
                                        <uix:messageList name="nodeListForUI" multiple="true">
                                            <uix:contents childDataBinding="nodeListForUI@defaultBean@servletRequest">
                                                <uix:option textBinding="nodeName" valueBinding="nodeName"/>
                                            </uix:contents>
                                        </uix:messageList>
                                        
                                    </uix:contents>
                                </uix:labeledFieldLayout>
                            </uix:contents>
                        </uix:header>   
                        <uix:header textBinding="INIT_PARAMS@asmConfMsgs">
                            <uix:contents>
                                
                            <uix:labeledFieldLayout>
                                <uix:contents>
                                    <uix:messageStyledText promptBinding="DISK_DISCOVERY_PATH@asmConfMsgs" textBinding="diskDiscoveryPathForReview@defaultBean@servletRequest" styleClass="OraDataText"/>
                                    
                                    <uix:messageStyledText promptBinding="DIAG_DEST@asmConfMsgs" textBinding="diagnosticDest@defaultBean@servletRequest" styleClass="OraDataText"/>
                                    <uix:messageStyledText renderedBinding="version11AndAbove@defaultBean@servletRequest" promptBinding="MEMORY_TARGET@asmConfMsgs" textBinding="memoryTargetForReview@defaultBean@servletRequest" styleClass="OraDataText"/>
                                    <uix:messageStyledText promptBinding="SHARED_POOL_SIZE@asmConfMsgs" textBinding="sharedPoolSizeForReview@defaultBean@servletRequest" styleClass="OraDataText"/>
                                    <uix:messageStyledText promptBinding="LARGE_POOL_SIZE@asmConfMsgs" textBinding="largePoolSizeForReview@defaultBean@servletRequest" styleClass="OraDataText"/>
                                </uix:contents>
                            </uix:labeledFieldLayout>
                                    
                            </uix:contents>
                        </uix:header>
                        <uix:header textBinding="DISK_GROUPS@asmConfMsgs">
                          <uix:contents>
                           <uix:spacer height="10" width="10"/>
                              <uix:tableLayout hAlign="left" width="100%">
                                  <uix:contents>
                                      <uix:rowLayout>
                                          <uix:contents>
                                              <uix:dataScope currentDataBinding="DISK_GROUPS_LIST@servletRequest">
                                                  <uix:table name="DISK_GROUPS_LIST" 
                                                             alternateTextBinding="diskGroupsAlterText"
                                                             formSubmitted="true"
                                                             width="100%"
                                                             tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                             minValue="1"
                                                             valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                             blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                             maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                                             summaryBinding="diskGroupsSummary">
                                                      
                                                      
                                                      <uix:tableFormat tableBanding="rowBanding"/>
                                                      <uix:column>
                                                          <uix:columnHeader>
                                                              <uix:sortableHeader textBinding="DG_NAME@asmConfMsgs"/>
                                                          </uix:columnHeader> 
                                                          <uix:columnFormat columnDataFormat="textFormat" width="40%"/>
                                                          <uix:messageStyledText textBinding="dgName" />
                                                      </uix:column>
                                                      <uix:column>
                                                          <uix:columnHeader>
                                                              <uix:sortableHeader  textBinding="NUM_OF_DISKS@asmConfMsgs"/>
                                                          </uix:columnHeader> 
                                                          <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                                          <uix:messageStyledText textBinding="numOfDisks" />
                                                      </uix:column>
                                                      <uix:column>
                                                          <uix:columnHeader>
                                                              <uix:sortableHeader  textBinding="REDUNDANCY@asmConfMsgs"/>
                                                          </uix:columnHeader> 
                                                          <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                                          <uix:messageStyledText textBinding="redundancy" />
                                                      </uix:column>
                                                      
                                                  </uix:table>
                                              </uix:dataScope>
                                          </uix:contents>
                                      </uix:rowLayout>
                                      
                                  </uix:contents>
                              </uix:tableLayout> 
                          </uix:contents>
                        </uix:header>
                        <uix:header renderedBinding="version112AndAbove@defaultBean@servletRequest" textBinding="SPFILE_LOC@asmConfMsgs">
                                <uix:contents>
                                    
                                    <uix:spacer height="10" width="10"/>
                                    <uix:labeledFieldLayout width="70%">
                                        <uix:contents>
                                            <uix:messageStyledText styleClass="OraDataText" promptBinding="DISKGROUP@asmConfMsgs" textBinding="dgForSpfileForDisplay@defaultBean@servletRequest"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                </uix:contents>
                            </uix:header>
                       <uix:header renderedBinding="versionBelow112@defaultBean@servletRequest"  textBinding="LISTENER_CONFIG@asmConfMsgs">
                          <uix:contents>
                              <uix:labeledFieldLayout>
                                  <uix:contents>
                                      <uix:messageStyledText textBinding="listenerName@ListenersBean@servletRequest"
                                                           promptBinding="LISTENER_NAME@listenersBundle@servletRequest"
                                                            styleClass="OraDataText"/>
                                      <uix:messageStyledText textBinding="listenerPort@ListenersBean@servletRequest"
                                                            promptBinding="PORT@listenersBundle@servletRequest"
                                                            styleClass="OraDataText" />
                                      
                                  </uix:contents>
                              </uix:labeledFieldLayout> 
                            
                          </uix:contents>
                        </uix:header>
                        <uix:header renderedBinding="version112AndAbove@defaultBean@servletRequest" textBinding="LISTENER_CONFIG@asmConfMsgs">
                                <uix:contents>
                                    
                                    <uix:labeledFieldLayout width="70%">
                                        <uix:contents>
                                            <uix:messageStyledText styleClass="OraDataText" promptBinding="DEF_LSNR_PORT@asmConfMsgs" textBinding="defaultListenerPort@defaultBean@servletRequest"/>
                                        </uix:contents>
                                    </uix:labeledFieldLayout>
                                </uix:contents>
                            </uix:header>
                    </uix:contents>
                    
                    
                    <!-- navigation -->
                    <uix:pageButtons>
         
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="3" formSubmitted="true" value="3" />
                                <uix:submitButton textBinding="FINISH@dbInstMsgs" shortDescBinding="FINISH@dbInstMsgs" name="event" value="apply" />
                            </uix:contents>
                        </uix:pageButtonBar>
                         </uix:pageButtons>
                        <uix:location>
                        <uix:train formSubmitted="true" value="3">
                          
                          <uix:contents>
                            <uix:link shortDescBinding="SELECT_DESTINATION@asmConfMsgs" textBinding="SELECT_DESTINATION@asmConfMsgs"/>
                            <uix:link shortDescBinding="CONF_SETTINGS@asmConfMsgs" textBinding="CONF_SETTINGS@asmConfMsgs"/>
                            <uix:link shortDescBinding="REVIEW@asmConfMsgs" textBinding="REVIEW@asmConfMsgs"/>
                          </uix:contents>
                        
                        </uix:train>
                      </uix:location>
                   
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
