<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/> 
    <uix:bundle name="asmConfMsgs" class="oracle.sysman.db.rsc.config.ASMConfigMsg"/>
    <uix:bundle name="osmMsgs" class="oracle.sysman.db.rsc.osm.OsmObjectMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>
        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>

            <uix:body>
            <db:form name="createDiskgroup" method="post" destination="/console/database/asmconf" copyParams="target,type,selectedDGIndex">
                <uix:formValue name="pageName" value="/database/util/config/createDiskgroup"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:formValue name="selectedDGIndex" valueBinding="selectedDGIndex@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="warning" 
                    errorTableBinding="warnings@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                        <uix:contents>
                        <%-------------------------
             -  Labeled Fields
             ---------------------------%>
            <uix:tableLayout cellSpacing="5">

                <%---------------------%>
                <%---  DG Name    ---%>
                <%---------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt required="yes" labeledNodeId="dgName" 
                      promptBinding="NAME@osmMsgs"/>
                  </uix:cellFormat>

                  <%---  Field  ---%>
                  <uix:cellFormat>
                        <uix:textInput id="dgName" 
                          name="dgName"
                          textBinding="dgName@dgBean@servletRequest"
                          columns="50"/>
                  </uix:cellFormat>

                </uix:rowLayout>
     
                <%--------------------------%>
                <%---  Redundancy ---%>
                <%--------------------------%>
                <uix:rowLayout>

                  <%---  Prompt  ---%>
                  <uix:cellFormat hAlign="right" vAlign="top">
                    <uix:styledText
                      styleClass="OraPromptText"
                      textBinding="REDUNDANCY@osmMsgs"/>
                  </uix:cellFormat>
		  
                  <%---  Field  ---%>
                    <uix:cellFormat>
                        <uix:contents>
                            <uix:messageRadioSet name="redundancy" selectedValueBinding="redundancy@dgBean@servletRequest">
                                <uix:contents>
                                    <uix:option shortDescBinding="HIGH@asmConfMsgs" textBinding="HIGH@asmConfMsgs" value="HIGH"/>
                                    <uix:option shortDescBinding="NORMAL@asmConfMsgs" textBinding="NORMAL@asmConfMsgs" value="NORMAL"/>
                                    <uix:option shortDescBinding="EXTERNAL@asmConfMsgs" textBinding="EXTERNAL@asmConfMsgs" value="EXTERNAL"/>
                                </uix:contents>
                            </uix:messageRadioSet>
                            
                        </uix:contents>                       
                    </uix:cellFormat>
                    
                </uix:rowLayout>

                

            </uix:tableLayout>
            <uix:spacer height="10" width="10"/>
            <%---------------------------
             -   Select Disks Table        -
             ---------------------------%>
             <uix:header textBinding="MEMBER_DISKS@osmMsgs" >
                 <uix:dataScope currentDataBinding="DISKS_LIST@servletRequest">
                     <uix:table name="DISKS_LIST" 
                                alternateTextBinding="disksAlterText"
                                formSubmitted="true"
                                width="100%"
                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                minValue="1"
                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                summaryBinding="disksSummary">
                         
                         
                         <uix:tableFormat tableBanding="rowBanding"/>
                         <uix:column>
                             <uix:columnHeader>
                                 <uix:sortableHeader textBinding="PATH@osmMsgs"/>
                             </uix:columnHeader> 
                             <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                             <uix:messageStyledText textBinding="diskPath" />
                         </uix:column>
                         <uix:column>
                             <uix:columnHeader>
                                 <uix:sortableHeader  textBinding="HEADER_STATUS@osmMsgs"/>
                             </uix:columnHeader> 
                             <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                             <uix:messageStyledText textBinding="diskHeader" />
                         </uix:column>
                         <uix:column>
                             <uix:columnHeader>
                                 <uix:sortableHeader  textBinding="LABEL@osmMsgs"/>
                             </uix:columnHeader> 
                             <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                             <uix:textInput name="asmName" textBinding="asmName" shortDescBinding="LABEL@osmMsgs"/>
                         </uix:column>
                         <uix:column>
                             <uix:columnHeader>
                                 <uix:sortableHeader  textBinding="FAILGROUP@osmMsgs"/>
                             </uix:columnHeader> 
                             <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                             <uix:textInput name="failGroup" textBinding="failGroup" shortDescBinding="FAILGROUP@osmMsgs"/>
                         </uix:column>
                         <uix:column>
                             <uix:columnHeader>
                                 <uix:sortableHeader  textBinding="SIZE@asmConfMsgs"/>
                             </uix:columnHeader> 
                             <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                             <uix:textInput name="size" textBinding="diskSize" shortDescBinding="SIZE@asmConfMsgs"/>
                         </uix:column>
                         <uix:column>
                             <uix:columnHeader>
                                 <uix:sortableHeader  textBinding="FORCE_USAGE@osmMsgs"/>
                             </uix:columnHeader> 
                             <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                             <uix:messageCheckBox name="force" checkedBinding="force" shortDescBinding="FORCE_USAGE@osmMsgs"/>
                         </uix:column>
                         <uix:tableSelection>
                             <uix:multipleSelection shortDescBinding="MEMBER_DISKS@osmMsgs" selectedBinding="<%= UIXDataSource.S_SELECT_ATTR %>">
                                
                             </uix:multipleSelection>
                         </uix:tableSelection>
                         <uix:tableFilter>
                   <uix:rowLayout>
                     <uix:contents>
                       <uix:cellFormat hAlign="left" vAlign="middle" wrappingDisabled="true">
                       <uix:styledText labeledNodeId="diskType" textBinding="SELECT_DISKS@osmMsgs" styleClass="OraPromptText" />                      
                       </uix:cellFormat>
                       <uix:cellFormat hAlign="left" vAlign="middle">
                       <uix:choice id="diskType" name="diskType"
                        selectedValueBinding="diskType" disabledBinding="versionBelow102@defaultBean@servletRequest" 
                        onChange="submitForm('createDiskgroup',true,{'event':'changeDiskType'})">
                       <uix:option textBinding="SHOW_CANDIDATES@osmMsgs" value="CANDIDATE"/> 
                       <uix:option textBinding="SHOW_ALL@osmMsgs" value="ALL"/>
                       </uix:choice>
                     </uix:cellFormat>
                   </uix:contents>                    
                </uix:rowLayout>
              </uix:tableFilter>
                     </uix:table>
                 </uix:dataScope>
                 
  
	    <uix:switcher childNameBinding="diskTypeChanged@servletRequest">
		<uix:case name="true">    	
			<uix:messageText messageBinding="MEMBER_DISK_SELECTION_LOST_MSG@osmMsgs"
                             messageType="warning"/>
		</uix:case>				
	    </uix:switcher>             
           </uix:header>
            
           <uix:spacer height="10" width="10"/>
     
                        </uix:contents>
                                                
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancelConfigDg" /> 
                                <uix:submitButton textBinding="OK@dbMsgs" name="event" value="applyConfigDg" /> 
                            </uix:contents>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                     
                    </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
                        
