<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>

<db:script src="/cabo/jsLibs/TableProxy.js"/>
    <script language="javascript">

function returnSelect()
{
    lenName = "oracleHomesList:length";
    if ((document.forms[0][lenName] != null))
    {
        selectItemValue = "";
        proxy = new TableProxy('oracleHomesList');
    
        selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
            homeName = "oracleHomesList:homeNameVal:"+selectedIndex;
            selectItemValue = document.forms[0][homeName].value;
            if (selectItemValue == null)
                selectItemValue = "";
        }
          top.window.opener.lovCallBack(selectItemValue);
    
    }
    top.close();
}

</script>
<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="asmConfMsgs" class="oracle.sysman.db.rsc.config.ASMConfigMsg"/>
    
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
   
            <uix:head titleBinding="title@servletRequest"/>

    </uix:metaContainer>
    
    <uix:body>

   <db:form name="hostTargetsLov" method="post" 
            destination="/console/database/asmconf" copyParams="target,type,">

              <uix:pageLayout titleBinding="header@servletRequest">
         
        <uix:formValue name="pageName" value="/database/util/config/oracleHomesList"/>
          <uix:tableLayout cellSpacing="2" width="80%">
         <uix:dataScope currentDataBinding="oracleHomesList@servletRequest">
            
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <uix:table name="oracleHomesList" 
                                                alternateTextBinding="homesAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="ORACLE_HOME@asmConfMsgs" sortable="false"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="homeName" />
                                                <uix:formValue name="homeNameVal" valueBinding="homeName"/>
                                                </uix:column>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="VERSION@asmConfMsgs" sortable="false"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="homeVersion" />
                                                <uix:formValue name="homeVersionVal" valueBinding="homeVersion"/>
                                                </uix:column>
                                                <uix:tableSelection>
                                                <uix:singleSelection shortDescBinding="SELECT@dbMsgs" selectedIndex="0"/>
                                            </uix:tableSelection>
                                                </uix:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        </uix:dataScope>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" onClick="javascript:self.close();" />
            <uix:button shortDescBinding="SELECT@dbMsgs" textBinding="SELECT@dbMsgs" onClick="returnSelect();" />
            
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>

   </uix:body>
  </uix:document>
 </uix:renderingContext>
