<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/> 
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dbInstMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/> 
    <uix:bundle name="asmConfMsgs" class="oracle.sysman.db.rsc.config.ASMConfigMsg"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>

        <script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <script>
        function startOracleHomeLov(lovUrl)
        {
           openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
        }
        
        function lovCallBack(data)
        {
           document.forms[0].asmHome.value=data
        }
        </script>

            <uix:body>
            <db:form name="selectDest" method="post" destination="/console/database/asmconf" copyParams="target,type,">
                <uix:formValue name="pageName" value="/database/util/config/selectDest"/>
                <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                <uix:pageLayout titleBinding="header@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <uix:contents>
                        
                        
                        <spacer height="20" width="10"/>
                        <uix:labeledFieldLayout width="60%">
                                          <uix:contents>
                                              <uix:messageStyledText renderedBinding="nonClusterTarget@defaultBean@servletRequest" promptBinding="HOST@asmConfMsgs" textBinding="host@defaultBean@servletRequest" styleClass="OraDataText"/>  
                                              <uix:messageStyledText renderedBinding="clusterTarget@defaultBean@servletRequest" promptBinding="CLUSTER@asmConfMsgs" textBinding="host@defaultBean@servletRequest" styleClass="OraDataText"/>
                                          </uix:contents>
                                      </uix:labeledFieldLayout>
                                      <uix:separator/>
                        <uix:tableLayout>
                          <uix:contents>
                            <uix:rowLayout width="100%">
                              <uix:contents>
                                <uix:cellFormat width="65%">
                                  <uix:contents>
                                      
                                      
                                                
                                                <uix:header textBinding="ORACLE_HOME@asmConfMsgs">
                                                  <uix:spacer height="10" width="10"/> 
                                                  <uix:styledText styleClass="oraInstructionText" textBinding="SELECT_ORA_HOME_INSTR@asmConfMsgs"/>
                                                        <uix:spacer height="10" width="10"/>
                                                    <uix:contents>
                                                        <uix:labeledFieldLayout>
                                                            <uix:contents>
                                                                
                                                                <uix:messageLovField columns="30" textBinding="asmHome@defaultBean@servletRequest" name="asmHome" 
                                                                                     promptBinding="ORACLE_HOME@asmConfMsgs" required="uiOnly"  shortDescBinding="ORACLE_HOME@asmConfMsgs" 
                                                                                     searchDescBinding="ORACLE_HOME@asmConfMsgs"  onClickBinding="lovDestForOracleHomes@servletRequest"/>
                                                            </uix:contents>
                                                        </uix:labeledFieldLayout>
                                                        
                                                    </uix:contents>
                                                </uix:header> 
                                                <uix:header textBinding="ASM_CREDS@asmConfMsgs">
                                                            <uix:contents>
                                                                
                                                                <uix:messageStyledText styleClass="OraInstructionText" textBinding="ASM_CREDS_INSTR@asmConfMsgs"/>
                                                                <uix:spacer height="10" width="10"/>
                                                                <uix:labeledFieldLayout>
                                                                    <uix:contents>
                                                                        <uix:messageTextInput columns="30" name="sysPassword" promptBinding="PASSWORD@asmConfMsgs" required="uiOnly" noAutoComplete="true" secret="true" textBinding="sysPassword@defaultBean@servletRequest"/>
                                                                        <uix:messageTextInput columns="30" name="sysConfirmPassword" promptBinding="CONFIRM_PASSWORD@asmConfMsgs" noAutoComplete="true" secret="true" required="uiOnly" textBinding="sysConfirmPassword@defaultBean@servletRequest"/>
                                                                    </uix:contents>
                                                                </uix:labeledFieldLayout>
                                                                
                                                            </uix:contents>
                                                        </uix:header> 
                                                <uix:header textBinding="HOST_CREDS@asmConfMsgs">
                                                    
                                                    <uix:contents>
                                                        
                                                        <uix:messageStyledText styleClass="oraInstructionText" textBinding="HOST_CREDS_INSTR@asmConfMsgs"/>
                                                        <uix:spacer height="10" width="10"/>
                                                        <uix:rowLayout>
                                                            <uix:contents>
                                                                <%@ include file="/credentials.jspf"%>
                                                            </uix:contents>
                                                        </uix:rowLayout>
                                                    </uix:contents>
                                                </uix:header> 
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:contents>
                                                <uix:spacer height="10" width="10"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat width="35%" vAlign="top">
                                            <uix:contents>
                                                <uix:contentContainer textBinding="OVERVIEW@asmConfMsgs" width="100%">
                                                    <uix:contents>
                                                        <uix:styledList listStyle="circle">
                                                            
                                                            
                                                            <uix:contents> 
                                                                
                                                                <uix:spacer height="10" width="10"/>
                                                                <uix:styledItem>
                                                                    <uix:contents>
                                                                        <uix:styledText styleClass="oraInstructionText" textBinding="OVERVIEW_1@asmConfMsgs"/>
                                                                    </uix:contents>
                                                                </uix:styledItem>
                                                                <uix:spacer height="10" width="10"/>
                                                                <uix:styledItem>
                                                                    <uix:contents>
                                                                        <uix:styledText styleClass="oraInstructionText" textBinding="OVERVIEW_2@asmConfMsgs"/>
                                                                    </uix:contents>
                                                                </uix:styledItem>
                                                                <uix:spacer height="10" width="10"/>
                        
                                                            </uix:contents>
                                                            
                                                            
                                                        </uix:styledList>
                                                        
                                                    </uix:contents>
                                                </uix:contentContainer>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                        
                    </uix:contents>
                    
                    
                    <!-- navigation -->
                    <uix:pageButtons>
         
                        <uix:pageButtonBar>
                            <uix:contents>
                                <uix:submitButton textBinding="CANCEL@dbMsgs" name="event" value="cancel" /> 
                                <uix:navigationBar maxValue="3" formSubmitted="true" value="1" renderedBinding="enableNavigation@servletRequest"/>
                            </uix:contents>
                        </uix:pageButtonBar>
                         </uix:pageButtons>
                        <uix:location>
                        <uix:train formSubmitted="true" value="1" renderedBinding="enableNavigation@servletRequest">
                          
                          <uix:contents>
                            <uix:link shortDescBinding="SELECT_DESTINATION@asmConfMsgs" textBinding="SELECT_DESTINATION@asmConfMsgs"/>
                            <uix:link shortDescBinding="CONF_SETTINGS@asmConfMsgs" textBinding="CONF_SETTINGS@asmConfMsgs"/>
                            <uix:link shortDescBinding="REVIEW@asmConfMsgs" textBinding="REVIEW@asmConfMsgs"/>
                            
                          </uix:contents>
                        
                        </uix:train>
                      </uix:location>
                   
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
                  
    </uix:document>
</uix:renderingContext>
