<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%--

 How to use this file:

 The following attributes must be set in ServletRequest:
  "destNo"      - URL for No button
  "destYes"     - URL for Yes button
  "warningText" - Brief warning plus yes/no question
  "explanation" - ancillary explanatory text (may be empty, but not null)

--%>

<html>

<head>
  <oem:title msgBundleKey="DBObjectBundle" textNLS="WARNING"/>
  <oem:styleSheet/>
</head>

<oem:body>
  <oem:contents>
    <oem:pageLayout>
      <%@ include file="/oemPageGlobal.jspf" %>
      <oem:contentFooter>
        <oem:pageButtonBar>
          <oem:contents>
            <oem:flowLayout>
              <oem:contents>
                <oem:button msgBundleKey="DBObjectBundle" textNLS="NO" destinationKey="destNo"/>
                <oem:spacer width="3"/>
                <oem:button msgBundleKey="DBObjectBundle" textNLS="YES" destinationKey="destYes"/>
              </oem:contents>
            </oem:flowLayout>
          </oem:contents>
        </oem:pageButtonBar>
      </oem:contentFooter>
      <oem:contents>
        <oem:header msgBundleKey="DBObjectBundle" textNLS="WARNING" icon="/images/warning.gif"/>
        <oem:rowLayout>
          <oem:contents>
            <oem:spacer width="25"/>
            <oem:stackLayout>
              <oem:spacer height="10"/>
              <oem:styledText styleClass="OraInstructionTextStrong" textKey="warningText"/>
              <oem:spacer height="25"/>
              <oem:styledText styleClass="OraInstructionText" textKey="explanation"/>
            </oem:stackLayout>
          </oem:contents>
        </oem:rowLayout>
      </oem:contents>
    </oem:pageLayout>
  </oem:contents>
</oem:body>

</html>
