<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="environmentCheckPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>

        <db:form name="form"
          destinationBinding="destination@defaultBean@servletRequest"
          method="post" copyParams="target,type">

          <uix:formValue name="pageName"
            value="/database/workload/captureEnvironmentCheck"/>

          <uix:pageLayout titleBinding="environmentCheckPageHeader@defaultBean@servletRequest">
            <%@ include file="/database/workload/train.jspf" %>

            <uix:stackLayout>
              <uix:rowLayout width="100%">
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="PROMPT_ENVIRONMENT_CHECK@defaultBundle@servletRequest"/>
              </uix:rowLayout>
              <uix:spacer height="10"/>
            </uix:stackLayout>

            <oem:table 
              width="100%"
              blockSizeBinding="rowCount@environmentCheckBean@servletRequest"
              summaryBinding="ENVIRONMENT_CHECKS@defaultBundle@servletRequest"
              partialRenderMode="self"
              formSubmitted="true"
              id="environmentCheckTable"
              name="environmentCheckUIDataSource"
              beanKey="environmentCheckBean"
              dataSourceProp="environmentCheckUIDataSource"
              alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
            </oem:table>
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
