<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript">
function hideExportButtonDisabled()
{
    var exportAwrButtonImageDisabled =
        document.getElementById('exportAwrButtonDisabled');

    exportAwrButtonImageDisabled.style.visibility = 'hidden';
    exportAwrButtonImageDisabled.height = 0;
    exportAwrButtonImageDisabled.width = 0;

    var exportAwrButton =
        document.getElementById('exportAwrButton');
    var exportAwrButtonImage =
        exportAwrButton.getElementsByTagName('img')[0];

    // save disabled and enabled image source and alt text
    exportAwrButton.enabledOnClick = exportAwrButton.onclick;
    exportAwrButtonImage.enabledSrc = exportAwrButtonImage.src;
    exportAwrButtonImage.enabledAlt = exportAwrButtonImage.alt;
    exportAwrButtonImage.disabledSrc = exportAwrButtonImageDisabled.src;
}

function checkExportButton()
{
    var proxy = new TableProxy('capturesUIDataSource');
    var selectedIndex = proxy.getSelectedRow();

    if (selectedIndex >= 0)
    {
        var awrExported = proxy.getFormElement('awrExported', selectedIndex);
        var exportAwrButton = document.getElementById('exportAwrButton');

        if (awrExported != null && exportAwrButton != null)
        {
            var image = exportAwrButton.getElementsByTagName('img')[0];

            if (awrExported.value == 'NOT POSSIBLE')
            {
                image.src = image.disabledSrc;
                image.alt = "";
                exportAwrButton.onclick = function() { return false; };
                exportAwrButton.style.cursor = 'default';
            }
            else
            {
                image.src = image.enabledSrc;
                image.alt = image.enabledAlt;
                exportAwrButton.onclick = exportAwrButton.enabledOnClick;
                exportAwrButton.style.cursor = 'pointer';
            }
        }
    }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="viewCaptureHistoryPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body
      onLoad="hideExportButtonDisabled(); checkExportButton();">
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post"
        copyParams="target,type,returnURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/captureHistory"/>
      
        <uix:pageLayout
          titleBinding="viewCaptureHistoryPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/workload/errors.jspf" %>

<%--
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:button
                textBinding="OK@DBObjectBundle@servletRequest"
                shortDescBinding="OK@DBObjectBundle@servletRequest"
                destinationBinding="cancelURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
--%>
      
          <uix:pageStatus>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="right">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="PAGE_REFRESHED_TIME@sdkBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      styleClass="OraTipLabel"
                      textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:cellFormat hAlign="right">
                    <uix:button textBinding="REFRESH@DBObjectBundle@servletRequest"
                      shortDescBinding="REFRESH@DBObjectBundle@servletRequest"
                      destinationBinding="refreshDest@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:pageStatus>

<%--
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:pageButtonBar>
                <uix:button
                  textBinding="OK@DBObjectBundle@servletRequest"
                  shortDescBinding="OK@DBObjectBundle@servletRequest"
                  destinationBinding="cancelURL@servletRequest"/>
              </uix:pageButtonBar>
            </uix:rowLayout>
          </uix:tableLayout>
--%>
      
<%--
          <uix:header textBinding="SCHEDULED_CAPTURES@defaultBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" width="100%">
              <uix:rowLayout>
                <oem:table name="scheduledCapturesUIDataSource"
                  beanKey="scheduledCapturesBean" dataSourceProp="scheduledCapturesUIDataSource"
                  formSubmitted="true" width="100%" blockSize="10" partialRenderMode="self"
                  summaryBinding="SCHEDULED_CAPTURES@defaultBundle@servletRequest"
                  alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgBundle@servletRequest"
                  copyParams="target,type">
                 </oem:table>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
--%>
      
          <oem:table
            summaryBinding="CAPTURE_HISTORY@defaultBundle@servletRequest"
            width="100%" 
            blockSizeBinding="blockSize@captureHistoryBean@servletRequest"
            formSubmitted="true"
            id="capturesTable"
            name="capturesUIDataSource" 
            dataSourceProp="capturesUIDataSource"
            beanKey="captureHistoryBean"
            alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
            <uix:tableSelection>
              <uix:singleSelection 
                shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                selectedIndexBinding="selectedIndex@captureHistoryBean@servletRequest"
                onClick="checkExportButton()">
                <uix:submitButton
                  textBinding="VIEW@DBObjectBundle@servletRequest"
                  shortDescBinding="VIEW@DBObjectBundle@servletRequest"
                  name="event"
                  value="viewCaptureHistoryDetails"
                  formName="form"/>
                <uix:submitButton
                  textBinding="DELETE@DBObjectBundle@servletRequest"
                  shortDescBinding="DELETE@DBObjectBundle@servletRequest"
                  name="event"
                  value="deleteCapture"
                  formName="form"/>
                <uix:submitButton
                  id="exportAwrButton"
                  textBinding="EXPORT_AWR_DATA@workloadBundle@servletRequest"
                  shortDescBinding="EXPORT_AWR_DATA@workloadBundle@servletRequest"
                  name="event"
                  value="exportAwr"
                  formName="form"/>
              </uix:singleSelection>
            </uix:tableSelection>
          </oem:table>

          <uix:switcher
            childNameBinding="empty@captureHistoryBean@servletRequest">
            <uix:case name="false">
              <uix:stackLayout>
                <uix:spacer height="10"/>
                <uix:rowLayout>
                  <uix:tip
                    textBinding="whyExportAwrData@defaultBean@servletRequest"/>
                  <%-- hidden --%>
                  <uix:cellFormat width="0" height="0">
                    <uix:submitButton
                      id="exportAwrButtonDisabled"
                      disabled="true"
                      textBinding="EXPORT_AWR_DATA@workloadBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
