<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="optionsPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue name="pageName"
          value="/database/workload/captureOptions"/>

        <uix:pageLayout
          titleBinding="optionsPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:spacer height="10"/>

          <uix:header
            textBinding="RESTART_OPTIONS@defaultBundle@servletRequest">
            <uix:stackLayout>
              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="PROMPT_RESTART_OPTIONS@defaultBundle@servletRequest"/>
                <uix:spacer width="3"/>
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="WHY_RESTART_DATABASE@defaultBundle@servletRequest"/>
              </uix:flowLayout>
          
              <uix:spacer height="10"/>

              <uix:rowLayout>
                <oem:radioButton
                  name="restartOption"
                  selectedValueBinding="restartOption@defaultBean@servletRequest"
                  textBinding="TEXT_NO_RESTART@defaultBundle@servletRequest"
                  value="NO_RESTART"/>
              </uix:rowLayout>

              <uix:spacer height="5"/>

              <uix:rowLayout>
                <oem:radioButton
                  name="restartOption"
                  selectedValueBinding="restartOption@defaultBean@servletRequest"
                  textBinding="TEXT_RESTART@defaultBundle@servletRequest"
                  value="RESTART"/>
              </uix:rowLayout>

            </uix:stackLayout>
          </uix:header>

          <%@ include file="/database/workload/workloadFilters.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
