<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="parametersPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body
      onLoad="document.getElementById('startupPFileName').disabled=!document.getElementById('startupParameterPFile').checked;">
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue name="pageName"
          value="/database/workload/captureParameters"/>

        <uix:pageLayout
          titleBinding="parametersPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:spacer height="10"/>

          <uix:header
            textBinding="CAPTURE_PARAMETERS@defaultBundle@servletRequest">
            <uix:labeledFieldLayout fieldWidth="99%">
              <uix:messageTextInput
                name="captureName"
                promptBinding="CAPTURE_NAME@workloadBundle@servletRequest"
                shortDescBinding="CAPTURE_NAME@workloadBundle@servletRequest"
                textBinding="captureName@defaultBean@servletRequest"
                messageBinding="captureNameMessage@defaultBean@servletRequest"
                messageTypeBinding="captureNameMessageType@defaultBean@servletRequest"
                noAutoComplete="true"
                columns="40"
                maximumLength="64"
                required="uiOnly"/>
  
              <uix:spacer height="5"/>

              <uix:messageLayout
                promptBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
                shortDescBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
                messageBinding="captureDirectoryMessage@defaultBean@servletRequest"
                messageTypeBinding="captureDirectoryMessageType@defaultBean@servletRequest"
                vAlign="middle">
                <uix:rowLayout
                  vAlign="middle">
                  <uix:choice
                    name="captureDirectory" 
                    shortDescBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
                    selectedValueBinding="captureDirectory@defaultBean@servletRequest"
                    required="uiOnly">
                    <%@ include file="/database/workload/directoryObjectsSource.jspf" %>
                  </uix:choice>
                  <uix:spacer width="10"/>
                  <uix:submitButton
                    shortDescBinding="CREATE_DIRECTORY_OBJECT@workloadBundle@servletRequest"
                    textBinding="CREATE_DIRECTORY_OBJECT@workloadBundle@servletRequest"
                    formName="form"
                    name="event"
                    value="createDirObject"/>
                </uix:rowLayout>
              </uix:messageLayout>
            </uix:labeledFieldLayout>

            <uix:switcher
              childNameBinding="rac@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:spacer height="10"/>
                  <uix:tip
                    textBinding="INFO_RAC_DIRECTORY_ACCESS@defaultBundle@servletRequest"/>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>

          </uix:header>

          <uix:switcher
            childNameBinding="restartDatabase@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:stackLayout>

                <uix:header
                  textBinding="SHUTDOWN_PARAMETERS@defaultBundle@servletRequest">
<%--
                    <uix:rowLayout>
                      <oem:radioButton
                        name="shutdownParameter"
                        selectedValueBinding="shutdownParameter@defaultBean@servletRequest"
                        textBinding="TEXT_SHUTDOWN_NORMAL@defaultBundle@servletRequest"
                        value="NORMAL"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:spacer width="20"/>
                      <uix:styledText styleClass="OraInlineInfoText"
                        textBinding="INFO_SHUTDOWN_NORMAL@defaultBundle@servletRequest"/>
                    </uix:rowLayout>
--%>
      
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <oem:radioButton
                      name="shutdownParameter"
                      selectedValueBinding="shutdownParameter@defaultBean@servletRequest"
                      textBinding="TEXT_SHUTDOWN_IMMEDIATE@defaultBundle@servletRequest"
                      shortDescBinding="TEXT_SHUTDOWN_IMMEDIATE@defaultBundle@servletRequest"
                      value="IMMEDIATE"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="0" width="30"/>
                    <uix:styledText styleClass="OraInlineInfoText"
                      textBinding="INFO_SHUTDOWN_IMMEDIATE@defaultBundle@servletRequest"/>
                  </uix:rowLayout>

                  <uix:spacer height="10"/>

                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <oem:radioButton
                      name="shutdownParameter"
                      selectedValueBinding="shutdownParameter@defaultBean@servletRequest"
                      textBinding="TEXT_SHUTDOWN_TRANSACTIONAL@defaultBundle@servletRequest"
                      shortDescBinding="TEXT_SHUTDOWN_TRANSACTIONAL@defaultBundle@servletRequest"
                      value="TRANSACTIONAL"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="0" width="30"/>
                    <uix:styledText styleClass="OraInlineInfoText"
                      textBinding="INFO_SHUTDOWN_TRANSACTIONAL@defaultBundle@servletRequest"/>
                  </uix:rowLayout>
    
                  <uix:spacer height="10"/>

                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <oem:radioButton
                      name="shutdownParameter"
                      selectedValueBinding="shutdownParameter@defaultBean@servletRequest"
                      textBinding="TEXT_SHUTDOWN_ABORT@defaultBundle@servletRequest"
                      shortDescBinding="TEXT_SHUTDOWN_ABORT@defaultBundle@servletRequest"
                      value="ABORT"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:spacer height="0" width="30"/>
                    <uix:styledText styleClass="OraInlineInfoText"
                      textBinding="INFO_SHUTDOWN_ABORT@defaultBundle@servletRequest"/>
                  </uix:rowLayout>
      
                  <uix:stackLayout
                    renderedBinding="rac@defaultBean@servletRequest">
                    <uix:spacer height="15"/>
                    <uix:rowLayout>
                      <uix:spacer width="10"/>
                      <uix:messageCheckBox
                        name="forceShutdown"
                        selectedValueBinding="forceShutdown@defaultBean@servletRequest"
                        textBinding="TEXT_FORCE_SHUTDOWN@defaultBundle@servletRequest"
                        shortDescBinding="TEXT_FORCE_SHUTDOWN@defaultBundle@servletRequest"
                        value="true"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:spacer height="0" width="30"/>
                      <uix:styledText styleClass="OraInlineInfoText"
                        textBinding="INFO_FORCE_SHUTDOWN@defaultBundle@servletRequest"/>
                    </uix:rowLayout>
                  </uix:stackLayout>
                </uix:header>
    
                <uix:header
                  textBinding="STARTUP_PARAMETERS@defaultBundle@servletRequest">
                  <uix:stackLayout>

<%--
                    <uix:rowLayout width="100%">
                      <uix:messagePrompt
                        messageType="info"
                        styleClass="OraInstructionText"
                        promptBinding="PROMPT_STARTUP_PARAMETERS@defaultBundle@servletRequest"/>
                    </uix:rowLayout>
                
                    <uix:spacer height="10"/>
--%>

                    <uix:rowLayout width="100%"
                      renderedBinding="notStartedWithSPFile@defaultBean@servletRequest">
                      <uix:stackLayout>
                        <uix:messageLayout messageType="info" vAlign="middle">
                          <uix:rowLayout vAlign="middle">
                            <uix:styledText
                              textBinding="startupSPFilePrompt@defaultBean@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
                          </uix:rowLayout>
                        </uix:messageLayout>
                        <uix:spacer height="10"/>
                      </uix:stackLayout>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:spacer width="10"/>
                      <oem:radioButton
                        name="startupParameter"
                        disabledBinding="notStartedWithSPFile@defaultBean@servletRequest"
                        selectedValueBinding="startupParameter@defaultBean@servletRequest"
                        textBinding="TEXT_STARTUP_DEFAULT@defaultBundle@servletRequest"
                        onClick="document.getElementById('startupPFileName').disabled=true;"
                        value="DEFAULT"/>
                    </uix:rowLayout>
      
                    <uix:spacer height="5"/>

                    <uix:rowLayout>
                      <uix:spacer width="10"/>
                      <oem:radioButton
                        id="startupParameterPFile"
                        name="startupParameter"
                        selectedValueBinding="startupParameter@defaultBean@servletRequest"
                        textBinding="TEXT_STARTUP_PFILE@defaultBundle@servletRequest"
                        onClick="document.getElementById('startupPFileName').disabled=false;"
                        value="PFILE"/>
                    </uix:rowLayout>

                    <uix:rowLayout>
                      <uix:spacer width="30"/>
                      <uix:messageTextInput
                        id="startupPFileName"
                        name="startupPFileName"
                        textBinding="startupPFileName@defaultBean@servletRequest"
                        shortDescBinding="TEXT_STARTUP_PFILE@defaultBundle@servletRequest"
                        messageBinding="startupPFileMessage@defaultBean@servletRequest"
                        messageTypeBinding="startupPFileMessageType@defaultBean@servletRequest"
                        noAutoComplete="true"
                        columns="64"
                        maximumLength="256"/>
                   </uix:rowLayout>
      
                  </uix:stackLayout>
                </uix:header>
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
