<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="homePageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post"
        copyParams="target,type">
        <uix:formValue name="pageName" value="/database/workload/captureReplayHome"/>

        <uix:pageLayout titleBinding="homePageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <uix:rawText>
            <meta http-equiv="expires" content="0">
          </uix:rawText>

          <uix:messages>
            <uix:stackLayout>
              <oem:messageBox
                messageTypeBinding="messageType@servletRequest"
                errorTableBinding="errors@servletRequest"
                destTableBinding="msgUrls@servletRequest"
                titleTextKey="titleText"
                mainTextKey="mainText"/>
  
              <uix:switcher childNameBinding="jobStatusMessageRendered@servletRequest">
                <uix:case name="true">
                  <uix:messageBox
                    messageType="confirmation"
                    messageBinding="jobStatusMessage@servletRequest">
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <uix:link
                          textBinding="VIEW_JOB@workloadBundle@servletRequest"
                          destinationBinding="jobSummaryDest@servletRequest"/>
                      </uix:rowLayout>
                      <uix:spacer height="5"/>
                      <uix:rowLayout>
                        <uix:messagePrompt
                          promptBinding="jobNextStepInstruction@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt
                          promptBinding="jobNextStep1@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt
                          promptBinding="jobNextStep2@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt
                          promptBinding="jobNextStep3@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt
                          promptBinding="jobNextStep4@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt
                          promptBinding="jobNextStep5@servletRequest"/>
                      </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:messageBox>
                </uix:case>
              </uix:switcher>
            </uix:stackLayout>
          </uix:messages>

          <uix:pageStatus>
            <uix:rowLayout width="100%">
              <uix:cellFormat hAlign="left" width="55%">
                <uix:styledText styleClass="OraInstructionText"
                    textBinding="OVERVIEW_PARAGRAPH_1@defaultBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="right" vAlign="top">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      styleClass="OraTipText"
                      textBinding="PAGE_REFRESHED_TIME@sdkBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      styleClass="OraTipLabel"
                      textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:cellFormat>
                    <uix:button textBinding="REFRESH@DBObjectBundle@servletRequest"
                      shortDescBinding="REFRESH@DBObjectBundle@servletRequest"
                      destinationBinding="refreshDest@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:pageStatus>
          
          <uix:tableLayout width="100%">
            <uix:rowLayout>
              <uix:spacer height="3"/>
            </uix:rowLayout>

            <uix:rowLayout>

              <uix:borderLayout>
                <uix:right>
                  <uix:contentContainer
                    textBinding="OVERVIEW_TITLE@defaultBundle@servletRequest"
                    width="480">

                    <uix:stackLayout>
                      <uix:styledText styleClass="OraInstructionText"
                          textBinding="OVERVIEW_PARAGRAPH_2@defaultBundle@servletRequest"/>
                      <uix:spacer height="10"/>
                      <uix:styledList listStyle="decimal">
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_1@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_2@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_3@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_4@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_5@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_6@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_7@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                        <uix:styledItem>
                          <uix:styledText styleClass="OraInstructionText"
                            textBinding="OVERVIEW_BULLET_8@defaultBundle@servletRequest"/>
                        </uix:styledItem>
                      </uix:styledList>
                    </uix:stackLayout>

                  </uix:contentContainer>
                </uix:right>

                <uix:stackLayout>
                  <uix:spacer height="3"/>
  
                  <oem:table
                    summaryBinding="PROMPT_OPERATION_TYPE@defaultBundle@servletRequest"
                    width="99%" 
                    blockSizeBinding="blockSize@captureReplayOperationBean@servletRequest"
                    formSubmitted="true"
                    partialRenderMode="self"
                    id="captureReplayOperationTable"
                    name="captureReplayOperationUIDataSource" 
                    dataSourceProp="captureReplayOperationUIDataSource"
                    beanKey="captureReplayOperationBean"
                    alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest"/>
  
                  <uix:spacer height="5"/>
  
                  <uix:link
                    shortDescBinding="TEXT_VIEW_CAPTURE_HISTORY@defaultBundle@servletRequest"
                    textBinding="TEXT_VIEW_CAPTURE_HISTORY@defaultBundle@servletRequest"
                    onClickBinding="captureHistoryDest@defaultBean@servletRequest"/>
                </uix:stackLayout>
                  
                <uix:rowLayout width="99%">
                  <uix:header
                    textBinding="ACTIVE_CAPTURE_REPLAY@defaultBundle@servletRequest">
                  
                      <oem:table
                        summaryBinding="ACTIVE_CAPTURE_REPLAY@defaultBundle@servletRequest"
                        width="100%" 
                        blockSizeBinding="blockSize@activeOperationBean@servletRequest"
                        formSubmitted="true"
                        partialRenderMode="self"
                        id="activeOperationTable"
                        name="activeOperationUIDataSource" 
                        dataSourceProp="activeOperationUIDataSource"
                        beanKey="activeOperationBean"
                        alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
                        <uix:tableSelection>
                          <uix:singleSelection 
                            shortDescBinding="SELECT@DBObjectBundle@servletRequest"
                            selectedIndex="0">
                            <uix:submitButton
                              textBinding="VIEW@DBObjectBundle@servletRequest"
                              shortDescBinding="VIEW@DBObjectBundle@servletRequest"
                              name="event"
                              value="viewActiveOperation"
                              formName="form"/>
                            <uix:submitButton
                              textBinding="STOP@workloadBundle@servletRequest"
                              shortDescBinding="STOP@workloadBundle@servletRequest"
                              name="event"
                              value="stopOperation"
                              formName="form"/>
                          </uix:singleSelection>
                        </uix:tableSelection>
                      </oem:table>
                  
                  </uix:header>
                </uix:rowLayout>

              </uix:borderLayout>

            </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
