<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript">
function hideExportButtonDisabled()
{
    var exportAwrButtonImageDisabled =
        document.getElementById('exportAwrButtonDisabled');

    exportAwrButtonImageDisabled.style.visibility = 'hidden';
    exportAwrButtonImageDisabled.height = 0;
    exportAwrButtonImageDisabled.width = 0;

    var exportAwrButton =
        document.getElementById('exportAwrButton');
    var exportAwrButtonImage =
        exportAwrButton.getElementsByTagName('img')[0];

    // save disabled and enabled image source and alt text
    exportAwrButton.enabledOnClick = exportAwrButton.onclick;
    exportAwrButtonImage.enabledSrc = exportAwrButtonImage.src;
    exportAwrButtonImage.enabledAlt = exportAwrButtonImage.alt;
    exportAwrButtonImage.disabledSrc = exportAwrButtonImageDisabled.src;
}

function checkExportButton()
{
    var proxy = new TableProxy('replaysUIDataSource');
    var selectedIndex = proxy.getSelectedRow();

    if (selectedIndex >= 0)
    {
        var awrExported = proxy.getFormElement('awrExported', selectedIndex);
        var exportAwrButton = document.getElementById('exportAwrButton');

        if (awrExported != null && exportAwrButton != null)
        {
            var image = exportAwrButton.getElementsByTagName('img')[0];

            if (awrExported.value == 'NOT POSSIBLE')
            {
                image.src = image.disabledSrc;
                image.alt = "";
                exportAwrButton.onclick = function() { return false; };
                exportAwrButton.style.cursor = 'default';
            }
            else
            {
                image.src = image.enabledSrc;
                image.alt = image.enabledAlt;
                exportAwrButton.onclick = exportAwrButton.enabledOnClick;
                exportAwrButton.style.cursor = 'pointer';
            }
        }
    }
}

function viewReport()
{
    var reportUrl = '<%=request.getAttribute("reportURL") == null ? "" : request.getAttribute("reportURL")%>';

    if (reportUrl.length > 0)
    {
        window.open(reportUrl, '_blank',
            'status=no, toolbar=no, location=no, menubar=no, directories=no, resizable=yes, scrollbars=yes');
        submitForm('form', true, { event: 'callback' });
    }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="captureReplaySummaryPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body
      onLoad="viewReport(); hideExportButtonDisabled(); checkExportButton();">
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue
          name="pageName"
          value="/database/workload/captureReplaySummary"/>

        <uix:pageLayout
          titleBinding="captureReplaySummaryPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/workload/errors.jspf" %>

          <uix:pageStatus>
            <uix:switcher childNameBinding="summaryPageShowPrompt@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout width="100%">
                  <uix:switcher childNameBinding="replayActive@defaultBean@servletRequest">
                    <uix:case name="true">
                        <uix:messagePrompt
                          styleClass="OraInstructionTextStrong"
                          messageType="warning"
                          promptBinding="summaryPagePrompt@defaultBean@servletRequest"/>
                    </uix:case>
                    <uix:default>
                        <uix:messagePrompt
                          styleClass="OraInstructionText"
                          promptBinding="summaryPagePrompt@defaultBean@servletRequest"/>
                    </uix:default>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                textBinding="CANCEL@DBObjectBundle@servletRequest"
                shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                destinationBinding="cancelURL@servletRequest"/>
              <uix:button
                disabledBinding="summaryPageNextDisabled@defaultBean@servletRequest"
                textBinding="summaryPageNextText@defaultBean@servletRequest"
                shortDescBinding="summaryPageNextText@defaultBean@servletRequest"
                destinationBinding="summaryPageNextDestination@defaultBean@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <%@ include file="/database/workload/pickDirectory.jspf" %>

          <uix:switcher
            childNameBinding="summaryPageShowCapture@defaultBean@servletRequest">
            <uix:case name="true">
              <%@ include file="/database/workload/captureSummary.jspf" %>
            </uix:case>
          </uix:switcher>

          <uix:spacer height="10"/>

          <uix:switcher
            childNameBinding="summaryPageShowCapture@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat width="40"/>
                  <uix:cellFormat>
                    <uix:hideShowHeader
                      id="captureDetails"
                      partialRenderMode="self"
                      formSubmitted="true"
                      disclosedBinding="showCaptureDetails@defaultBean@servletRequest"
                      textBinding="CAPTURE_DETAILS@workloadBundle@servletRequest">
                        <%@ include file="/database/workload/captureInfoTabs.jspf" %>
                    </uix:hideShowHeader>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher
            childNameBinding="summaryPageShowReplays@defaultBean@servletRequest">
            <uix:case name="true">
              <%@ include file="/database/workload/replayHistory.jspf" %>
            </uix:case>
          </uix:switcher>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
