<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="reviewPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue name="pageName"
          value="/database/workload/captureReview"/>

        <uix:pageLayout
          titleBinding="reviewPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:styledText
            styleClass="OraInstructionText"
            textBinding="REVIEW_INSTRUCTION@defaultBundle@servletRequest"/>
          <uix:spacer height="10"/>

          <uix:labeledFieldLayout>
            <uix:messageStyledText
              promptBinding="JOB_NAME@workloadBundle@servletRequest"
              shortDescBinding="JOB_NAME@workloadBundle@servletRequest"
              textBinding="jobName@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="CAPTURE_NAME@workloadBundle@servletRequest"
              shortDescBinding="CAPTURE_NAME@workloadBundle@servletRequest"
              textBinding="captureName@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
              shortDescBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
              textBinding="captureDirectory@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="START_TIME@workloadBundle@servletRequest"
              shortDescBinding="START_TIME@workloadBundle@servletRequest"
              textBinding="jobStartDate@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="CAPTURE_DURATION@workloadBundle@servletRequest"
              shortDescBinding="CAPTURE_DURATION@workloadBundle@servletRequest"
              textBinding="jobEndDate@defaultBean@servletRequest"
              styleClass="OraDataText"/>
          </uix:labeledFieldLayout>

          <uix:header
            textBinding="DATABASE_RESTART@defaultBundle@servletRequest">
            <uix:labeledFieldLayout width="97%">
              <uix:messageStyledText
                promptBinding="RESTART_DATABASE@defaultBundle@servletRequest"
                shortDescBinding="RESTART_DATABASE@defaultBundle@servletRequest"
                textBinding="restartDatabaseStatus@defaultBean@servletRequest"
                styleClass="OraDataText"/>

              <uix:messageStyledText
                promptBinding="SHUTDOWN_MODE@defaultBundle@servletRequest"
                shortDescBinding="SHUTDOWN_MODE@defaultBundle@servletRequest"
                textBinding="shutdownMode@defaultBean@servletRequest"
                renderedBinding="restartDatabase@defaultBean@servletRequest"
                styleClass="OraDataText"/>

              <uix:switcher
                childNameBinding="rac@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:messageStyledText
                    promptBinding="FORCE_SHUTDOWN@defaultBundle@servletRequest"
                    shortDescBinding="FORCE_SHUTDOWN@defaultBundle@servletRequest"
                    textBinding="forceShutdownStatus@defaultBean@servletRequest"
                    renderedBinding="restartDatabase@defaultBean@servletRequest"
                    styleClass="OraDataText"/>
                </uix:case>
              </uix:switcher>

              <uix:messageStyledText
                promptBinding="STARTUP_INIT_PARAMETER@defaultBundle@servletRequest"
                shortDescBinding="STARTUP_INIT_PARAMETER@defaultBundle@servletRequest"
                textBinding="startupInitParameter@defaultBean@servletRequest"
                renderedBinding="restartDatabase@defaultBean@servletRequest"
                styleClass="OraDataText"/>
            </uix:labeledFieldLayout>

          </uix:header>

          <%@ include file="/database/workload/workloadFilters.jspf" %>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
