<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="schedulePageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue name="pageName"
          value="/database/workload/captureSchedule"/>

        <uix:pageLayout
          titleBinding="schedulePageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:spacer height="10"/>

          <uix:stackLayout>
            <uix:header
              textBinding="JOB_PARAMETERS@workloadBundle@servletRequest">
              <uix:labeledFieldLayout labelWidth="10%">
                  <uix:messageTextInput
                    name="jobName"
                    promptBinding="JOB_NAME@workloadBundle@servletRequest"
                    shortDescBinding="JOB_NAME@workloadBundle@servletRequest"
                    textBinding="jobName@defaultBean@servletRequest"
                    messageBinding="jobNameMessage@defaultBean@servletRequest"
                    messageTypeBinding="jobNameMessageType@defaultBean@servletRequest"
                    noAutoComplete="true"
                    columns="50"
                    maximumLength="64"
                    required="uiOnly"/>
  
                  <uix:spacer height="5"/>
  
                  <uix:messageTextInput
                    name="jobDescription"
                    promptBinding="DESCRIPTION@workloadBundle@servletRequest"
                    shortDescBinding="DESCRIPTION@workloadBundle@servletRequest"
                    textBinding="jobDescription@defaultBean@servletRequest"
                    noAutoComplete="true"
                    columns="50"
                    maximumLength="128"/>
             </uix:labeledFieldLayout>
            </uix:header>

            <uix:spacer height="5"/>

            <uix:header
              textBinding="JOB_SCHEDULE@workloadBundle@servletRequest">

              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="SCHEDULE_INSTRUCTION@defaultBundle@servletRequest"/>

              <uix:spacer height="10"/>

              <uix:rowLayout width="100%">
                <uix:borderLayout>
  
                  <uix:left>
                    <%@ include file="/sdk/schedule/start.jspf" %>
                 </uix:left>
  
                  <uix:right>
                    <uix:header
                      textBinding="CAPTURE_DURATION@workloadBundle@servletRequest">

                      <uix:spacer height="5"/>

                      <uix:tableLayout width="100%">
                        <uix:messageRadioButton
                          name="scheduleEndType"
                          textBinding="NOT_SPECIFIED@sdkBundle@servletRequest"
                          shortDescBinding="NOT_SPECIFIED@sdkBundle@servletRequest"
                          messageBinding="INFO_NOT_SPECIFIED@workloadBundle@servletRequest"
                          selectedValueBinding="scheduleEndType@defaultBean@servletRequest"
                          value="NOT_SPECIFIED">
                        </uix:messageRadioButton>

                        <uix:messageRadioButton
                          name="scheduleEndType"
                          textBinding="DURATION@sdkBundle@servletRequest"
                          shortDescBinding="DURATION@sdkBundle@servletRequest"
                          messageBinding="(DURATION@sdkBundle@servletRequest)@errors@servletRequest"
                          messageTypeBinding="scheduleEndDurationMessageType@defaultBean@servletRequest"
                          selectedValueBinding="scheduleEndType@defaultBean@servletRequest"
                          value="DURATION">
                        </uix:messageRadioButton>
                      </uix:tableLayout>
  
                      <uix:rowLayout>
                        <uix:spacer width="50" height="32"/>

                        <uix:labeledFieldLayout>
                          <uix:rowLayout>
                            <uix:messageTextInput
                              promptBinding="HOURS@sdkBundle@servletRequest"
                              name="endDurationHours"
                              shortDescBinding="HOURS@sdkBundle@servletRequest"
                              textBinding="endDurationHours@defaultBean@servletRequest"
                              noAutoComplete="true"
                              columns="4"
                              maximumLength="4">
                              <uix:onSubmitValidater>
                                <uix:decimal minValue="0"/> 
                              </uix:onSubmitValidater>
                            </uix:messageTextInput>

                            <uix:spacer width="25"/>
  
                            <uix:messageTextInput
                              promptBinding="MINUTES@sdkBundle@servletRequest"
                              name="endDurationMinutes"
                              shortDescBinding="MINUTES@sdkBundle@servletRequest"
                              textBinding="endDurationMinutes@defaultBean@servletRequest"
                              noAutoComplete="true"
                              columns="4"
                              maximumLength="4">
                              <uix:onSubmitValidater>
                                <uix:decimal minValue="0"/> 
                              </uix:onSubmitValidater>
                            </uix:messageTextInput>

                          </uix:rowLayout>
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>

<%--
                      <uix:messageRadioButton
                        name="scheduleEndType"
                        textBinding="DATE@sdkBundle@servletRequest"
                        shortDescBinding="DATE@sdkBundle@servletRequest"
                        selectedValueBinding="scheduleEndType@defaultBean@servletRequest"
                        value="DATE">
                      </uix:messageRadioButton>
  
                      <uix:rowLayout>
                        <uix:spacer width="50" height="32"/>
                        <uix:labeledFieldLayout>
  
                          <uix:messageDateField
                            id="endDateSB"
                            name="endDateSB"
                            promptBinding="DATE@sdkBundle@servletRequest"
                            valueBinding="endDateSB@scheduleBean@pageContext"
                            tipBinding="dateTip@scheduleBean@servletRequest"
                            shortDescBinding="END_DATE@sdkBundle@servletRequest"
                            columns="24">
                            <uix:onSubmitValidater>
                              <uix:date dateStyle="medium"/> 
                            </uix:onSubmitValidater>
                          </uix:messageDateField>
  
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>
  
                      <uix:rowLayout>
                        <uix:spacer width="50" height="32"/>
                        <uix:labeledFieldLayout>
                          <uix:messagePrompt
                            promptBinding="TIME@sdkBundle@servletRequest"/>
  
                          <uix:rowLayout>
                            <oem:choice
                              name="endHourSB"
                              id="endHourSB"
                              optionsBinding="hoursSB@scheduleBean@servletRequest" 
                              shortDescBinding="HOURS@sdkBundle@servletRequest"
                              selectedValueBinding="endHourSB@scheduleBean@servletRequest"/>
                            
                            <uix:spacer width="5"/>
                            
                            <oem:choice 
                              name="endMinuteSB" 
                              id="endMinuteSB"
                              shortDescBinding="MINUTES@sdkBundle@servletRequest"
                              optionsBinding="minutesSB@scheduleBean@servletRequest" 
                              selectedValueBinding="endMinuteSB@scheduleBean@servletRequest"/>
                            
                            <uix:spacer width="5"/>
                            
                            <oem:choice 
                              name="endSecondSB" 
                              id="endSecondSB"
                              renderedBinding="showSeconds@scheduleBean@servletRequest" 
                              shortDescBinding="SECONDS@sdkBundle@servletRequest"
                              optionsBinding="secondsSB@scheduleBean@servletRequest" 
                              selectedValueBinding="endSecondSB@scheduleBean@servletRequest"/>
                            
                            <oem:radioButton
                                 name="endAmPmSB"
                                 value="AM_VALUE"
                                 selectedValueBinding="endAmPmSB@scheduleBean@servletRequest"
                                 textBinding="AM_LABEL@sdkBundle@servletRequest"
                                 shortDescBinding="AM_LABEL@sdkBundle@servletRequest"
                                 styleClass="OraInstructionText"/>
                            <oem:radioButton 
                                 name="endAmPmSB"
                                 value="PM_VALUE"
                                 selectedValueBinding="endAmPmSB@scheduleBean@servletRequest"
                                 textBinding="PM_LABEL@sdkBundle@servletRequest"
                                 shortDescBinding="PM_LABEL@sdkBundle@servletRequest"
                                 styleClass="OraInstructionText"/>
                          </uix:rowLayout>
  
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>
--%>
  
                    </uix:header>
                 </uix:right>

                </uix:borderLayout>
              </uix:rowLayout>
            </uix:header>

            <uix:spacer height="5"/>

            <uix:header
              textBinding="JOB_CREDENTIALS@workloadBundle@servletRequest">
              <uix:stackLayout>

<%--
                <uix:messageRadioButton
                  name="credentialsType"
                  textBinding="USE_PREFERRED_CREDENTIALS@workloadBundle@servletRequest"
                  shortDescBinding="USE_PREFERRED_CREDENTIALS@workloadBundle@servletRequest"
                  selectedValueBinding="credentialsType@credentialsBean@servletRequest"
                  value="USE_PREFERRED_CREDENTIALS"/>

                <uix:spacer height="5"/>

                <uix:messageRadioButton
                  name="credentialsType"
                  textBinding="OVERRIDE_PREFERRED_CREDENTIALS@workloadBundle@servletRequest"
                  shortDescBinding="OVERRIDE_PREFERRED_CREDENTIALS@workloadBundle@servletRequest"
                  selectedValueBinding="credentialsType@credentialsBean@servletRequest"
                  value="OVERRIDE_PREFERRED_CREDENTIALS"/>
--%>

                <uix:spacer height="5"/>

                <uix:rowLayout width="100%">
                  <uix:borderLayout>

                    <uix:left>
                      <%@ include file="/database/workload/hostCredentials.jspf" %>
                    </uix:left>

                    <uix:right>
                      <uix:switcher
                        childNameBinding="restartDatabase@defaultBean@servletRequest">
                        <uix:case name="true">
                          <%@ include file="/database/workload/databaseCredentials.jspf" %>
                        </uix:case>
                      </uix:switcher>
                    </uix:right>

                  </uix:borderLayout>  
                </uix:rowLayout>

              </uix:stackLayout>
            </uix:header>

          </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
