<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="EXPORT_AWR_DATA@workloadBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/confirmExportAwr"/>

        <uix:pageLayout
          messageType="confirmation"
          titleBinding="EXPORT_AWR_DATA@workloadBundle@servletRequest">
          <%@ include file="/database/globalPopup.jspf" %>

          <uix:stackLayout>
            <uix:rowLayout>
              <uix:spacer width="35"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="SURE_EXPORT_AWR_DATA@workloadBundle@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer width="35"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="WHY_EXPORT_AWR_DATA_DETAIL@workloadBundle@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout
              renderedBinding="exportAwrLaterRendered@defaultBean@servletRequest">
              <uix:stackLayout>
                <uix:spacer height="15"/>
                <uix:rowLayout>
                  <uix:spacer height="0" width="35"/>
                  <uix:tip
                    textBinding="EXPORT_AWR_DATA_LATER@defaultBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:stackLayout>
            </uix:rowLayout>
            <uix:rowLayout
              renderedBinding="diagnosticPackNotAvailable@defaultBean@servletRequest">
              <uix:stackLayout>
                <uix:switcher
                  childNameBinding="exportAwrLaterRendered@defaultBean@servletRequest">
                  <uix:case name="false">
                    <uix:spacer height="15"/>
                  </uix:case>
                </uix:switcher>
                <uix:rowLayout>
                  <uix:spacer height="0" width="35"/>
                  <uix:tip
                    textBinding="USE_REQUIRE_DIAG_PACK@workloadBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:stackLayout>
            </uix:rowLayout>
          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@sdkBundle@servletRequest"
                destinationBinding="returnURL@servletRequest"/>
              <uix:button textBinding="YES@sdkBundle@servletRequest"
                disabledBinding="diagnosticPackNotAvailable@defaultBean@servletRequest"
                destinationBinding="forwardURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
