<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="IMPORT_AWR_DATA@workloadBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,returnURL,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/confirmImportAwr"/>

        <uix:pageLayout
          messageType="confirmation"
          titleBinding="IMPORT_AWR_DATA@workloadBundle@servletRequest">
          <%@ include file="/database/globalPopup.jspf" %>

          <uix:stackLayout>
            <uix:rowLayout>
              <uix:spacer width="35"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="WHY_IMPORT_AWR_DATA_DETAIL@workloadBundle@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout
              renderedBinding="awrImportIncomplete@reportBean@servletRequest">
              <uix:spacer width="35"/>
              <uix:styledText
                styleClass="OraInstructionTextStrong"
                textBinding="INCOMPLETE_AWR_IMPORT@workloadBundle@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer width="35"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="SURE_IMPORT_AWR_DATA@workloadBundle@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout
              renderedBinding="diagnosticPackNotAvailable@defaultBean@servletRequest">
              <uix:spacer width="35"/>
              <uix:tip
                textBinding="USE_REQUIRE_DIAG_PACK@workloadBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:stackLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@sdkBundle@servletRequest" 
                destinationBinding="returnURL@servletRequest"/>
              <uix:button textBinding="YES@sdkBundle@servletRequest" 
                disabledBinding="diagnosticPackNotAvailable@defaultBean@servletRequest"
                destinationBinding="forwardURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
