<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/preprocessSchedule"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:messagePrompt
            styleClass="OraInstructionText"
            promptBinding="PROMPT_SCHEDULE@defaultBundle@servletRequest"/>

          <uix:spacer height="10"/>

          <uix:stackLayout>
            <uix:header
              textBinding="JOB_PARAMETERS@workloadBundle@servletRequest">
              <uix:labeledFieldLayout labelWidth="10%">
                  <uix:messageTextInput
                    name="jobName"
                    promptBinding="JOB_NAME@workloadBundle@servletRequest"
                    shortDescBinding="JOB_NAME@workloadBundle@servletRequest"
                    textBinding="jobName@defaultBean@servletRequest"
                    messageBinding="jobNameMessage@defaultBean@servletRequest"
                    messageTypeBinding="jobNameMessageType@defaultBean@servletRequest"
                    noAutoComplete="true"
                    columns="50"
                    maximumLength="64"
                    required="uiOnly"/>
  
                  <uix:spacer height="5"/>
  
                  <uix:messageTextInput
                    name="jobDescription"
                    promptBinding="DESCRIPTION@workloadBundle@servletRequest"
                    shortDescBinding="DESCRIPTION@workloadBundle@servletRequest"
                    textBinding="jobDescription@defaultBean@servletRequest"
                    noAutoComplete="true"
                    columns="50"
                    maximumLength="128"/>
             </uix:labeledFieldLayout>
            </uix:header>

            <uix:spacer height="5"/>

            <%@ include file="/sdk/schedule/start.jspf" %>

            <uix:spacer height="5"/>

            <%@ include file="/database/workload/hostCredentials.jspf" %>

          </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
