<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/preprocessVersion"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

            <uix:stackLayout>
              <uix:styledText
                styleClass="OraInstructionTextStrong"
                textBinding="preprocessVersionMessage@defaultBean@servletRequest"/>  
  
              <uix:spacer height="10"/>

              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="PREPROCESS_VERSION_MESSAGE@defaultBundle@servletRequest"/>
            </uix:stackLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
