<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.util.workload.WorkloadConstants" %>

<script language="JavaScript">
function alignConnectionsTableColumns()
{
    var span = document.getElementById('replayInfoConnectionsTable');
    var headers = span.getElementsByTagName('th');

    headers[0].width = headers[1].width = "50%";

    var cells = span.getElementsByTagName('td');

    for (var i = 0; i < cells.length; i++)
    {
        cells[i].style.verticalAlign = 'top';
    }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="alignConnectionsTableColumns();">
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/replayCustomizeOptions"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:spacer height="10"/>
  
          <%@ include file="/database/workload/replayInfoTabs.jspf" %>

        </uix:pageLayout>

      </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
