<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript">
var groupByErrorObserved = null;
function onChangeDivergenceTypeFilter()
{
  var typeFilter = document.getElementById('divergenceFilterByType');

  var observedErrorFilter =
   document.getElementById('divergenceFilterByErrorObserved');
  observedErrorFilter.disabled = 
   (typeFilter.options[typeFilter.selectedIndex].value == 'dmlDataDivergence' ||
    typeFilter.options[typeFilter.selectedIndex].value == 'queryDataDivergence');

  var groupBy = document.getElementById('divergenceGroupBy');
  if ((typeFilter.options[typeFilter.selectedIndex].value == 'dmlDataDivergence' ||
       typeFilter.options[typeFilter.selectedIndex].value == 'queryDataDivergence') &&
      groupByErrorObserved == null)
  {
    groupByErrorObserved = groupBy.options[1];
    groupBy.remove(1);
  }
  else if (!(typeFilter.options[typeFilter.selectedIndex].value == 'dmlDataDivergence' ||
             typeFilter.options[typeFilter.selectedIndex].value == 'queryDataDivergence') &&
           groupByErrorObserved != null)
  {
    try
    {
      groupBy.add(groupByErrorObserved, groupBy.options[1]);
    }
    catch(ex)
    {
      groupBy.add(groupByErrorObserved, 1);
    }
    groupByErrorObserved = null;
  }
}

function popUp()
{
  var popUpUrl = '<%=request.getAttribute("popUpUrl") == null ? "" : request.getAttribute("popUpUrl")%>';

  if (popUpUrl.length > 0)
  {
    var popUpWindow = '<%=request.getAttribute("popUpWindow") == null ? "_blank" : request.getAttribute("popUpWindow")%>';
    var popUpOptions = '<%=request.getAttribute("popUpOptions") == null ? "" : request.getAttribute("popUpOptions")%>';

    window.open(popUpUrl, popUpWindow, popUpOptions, true);
    submitForm('form', true, { event: 'callback' });
  }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="replayDivergenceDetailsPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="popUp(); onChangeDivergenceTypeFilter()">
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,replayId,cancelURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/replayDivergenceDetails"/>

        <uix:pageLayout
          titleBinding="replayDivergenceDetailsPageHeader@defaultBean@servletRequest">

          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/workload/errors.jspf" %>

          <%--
          <uix:pageStatus>
            <uix:rowLayout width="100%">
              <uix:messagePrompt
                styleClass="OraInstructionText"
                promptBinding="replayDivergenceDetailsPagePrompt@defaultBean@servletRequest"/>
            </uix:rowLayout>
          </uix:pageStatus>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                textBinding="OK@DBObjectBundle@servletRequest"
                shortDescBinding="OK@DBObjectBundle@servletRequest"
                destinationBinding="cancelURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          --%>

          <uix:styledText
            textBinding="REPLAY_DIVERGENCE_DETAILS_EXPLAINED@defaultBundle@servletRequest"
            styleClass="OraInstructionText"/>

          <uix:hideShowHeader
            id="divergedCallConditions"
            textBinding="REPLAY_DIVERGENCE_CONDITIONS_HIDESHOW@defaultBundle@servletRequest"
            formSubmitted="true"
            disclosedBinding="showDivergedCallConditions@defaultBean@servletRequest">

            <%-- Filters --%>
            <uix:header
              textBinding="REPLAY_DIVERGENCE_FILTER_HEADER@defaultBundle@servletRequest">
              <uix:stackLayout>
                <uix:styledText
                  textBinding="REPLAY_DIVERGENCE_FILTER_EXPLAINED@defaultBundle@servletRequest"
                  styleClass="OraInstructionText"/>
                <uix:spacer width="1" height="5"/>
                <uix:labeledFieldLayout columns="2" width="90%">
                  <uix:messageChoice
                    id="divergenceFilterByType"
                    name="divergenceFilterByType"
                    promptBinding="REPLAY_DIVERGENCE_TYPE@defaultBundle@servletRequest"
                    tipBinding="REPLAY_DIVERGENCE_TYPE_TIP@defaultBundle@servletRequest"
                    selectedValueBinding="divergenceFilterByType@divergingStatements@defaultBean@servletRequest"
                    onChange="onChangeDivergenceTypeFilter()">
                    <uix:contents>
                      <uix:option text="" value=""/>
                      <uix:option
                        textBinding="SESSION_FAILURES@defaultBundle@servletRequest"
                        value="sessionFailures"/>
                      <uix:option
                        textBinding="CAPTURE_ERRORS_NOT_IN_REPLAY@defaultBundle@servletRequest"
                        value="missingErrors"/>
                      <uix:option
                        textBinding="CAPTURE_ERRORS_MUTATED_IN_REPLAY@defaultBundle@servletRequest"
                        value="mutatedErrors"/>
                      <uix:option
                        textBinding="REPLAY_ERRORS_NOT_IN_CAPTURE@defaultBundle@servletRequest"
                        value="newErrors"/>
                      <uix:option
                        textBinding="DML_DIVERGENCE@defaultBundle@servletRequest"
                        value="dmlDataDivergence"/>
                      <uix:option
                        textBinding="SELECT_DIVERGENCE@defaultBundle@servletRequest"
                        value="queryDataDivergence"/>
                    </uix:contents>
                  </uix:messageChoice>
                  <uix:messageTextInput
                    promptBinding="REPLAY_DIVERGENCE_ATTR_ERROR_OBSERVED@defaultBundle@servletRequest"
                    textBinding="divergenceFilterByErrorObserved@divergingStatements@defaultBean@servletRequest"
                    tipBinding="REPLAY_DIVERGENCE_FILTER_ERROR_OBSERVED_TIP@defaultBundle@servletRequest"
                    id="divergenceFilterByErrorObserved"
                    name="divergenceFilterByErrorObserved"/>
                  <uix:spacer width="1" height="5"/>
                  <uix:spacer width="1" height="5"/>
                  <uix:spacer width="1" height="5"/>
                  <uix:spacer width="1" height="5"/>
                  <uix:messageTextInput
                    promptBinding="REPLAY_DIVERGENCE_ATTR_SQL_ID@defaultBundle@servletRequest"
                    textBinding="divergenceFilterBySqlId@divergingStatements@defaultBean@servletRequest"
                    name="divergenceFilterBySqlId"/>
                  <uix:messageTextInput
                    promptBinding="REPLAY_DIVERGENCE_ATTR_SERVICE@defaultBundle@servletRequest"
                    textBinding="divergenceFilterByService@divergingStatements@defaultBean@servletRequest"
                    name="divergenceFilterByService"/>
                  <uix:styledText
                    textBinding="REPLAY_DIVERGENCE_PROMPT_SESSION@defaultBundle@servletRequest"
                    styleClass="OraPromptText"/>
                  <uix:flowLayout>
                    <uix:textInput
                      columns="11"
                      textBinding="divergenceFilterBySessionId@divergingStatements@defaultBean@servletRequest"
                      name="divergenceFilterBySessionId"/>
                    <uix:styledText
                      text=":"
                      styleClass="OraDataText"/>
                    <uix:textInput
                      columns="11"
                      textBinding="divergenceFilterBySessionSerialNum@divergingStatements@defaultBean@servletRequest"
                      name="divergenceFilterBySessionSerialNum"/>
                  </uix:flowLayout>
                  <uix:messageTextInput
                    promptBinding="REPLAY_DIVERGENCE_ATTR_MODULE@defaultBundle@servletRequest"
                    textBinding="divergenceFilterByModule@divergingStatements@defaultBean@servletRequest"
                    name="divergenceFilterByModule"/>
                  <uix:spacer width="1" height="1"/>
                  <uix:spacer width="1" height="1"/>
                  <uix:messageTextInput
                    promptBinding="REPLAY_DIVERGENCE_ATTR_ACTION@defaultBundle@servletRequest"
                    textBinding="divergenceFilterByAction@divergingStatements@defaultBean@servletRequest"
                    name="divergenceFilterByAction"/>
                </uix:labeledFieldLayout>
              </uix:stackLayout>
            </uix:header>

            <%-- Group By --%>
            <uix:header
              textBinding="REPLAY_DIVERGENCE_GROUPBY_HEADER@defaultBundle@servletRequest">
              <uix:stackLayout>
                <uix:styledText
                  textBinding="REPLAY_DIVERGENCE_GROUPBY_EXPLAINED@defaultBundle@servletRequest"
                  styleClass="OraInstructionText"/>
                <uix:spacer width="1" height="5"/>
                <uix:labeledFieldLayout width="100%" labelWidth="15%">
                <uix:messageChoice
                  id="divergenceGroupBy"
                  name="divergenceGroupBy"
                  promptBinding="REPLAY_DIVERGENCE_GROUPBY_ATTRIBUTE@defaultBundle@servletRequest"
                  tipBinding="REPLAY_DIVERGENCE_GROUPBY_ATTRIBUTE_TIP@defaultBundle@servletRequest"
                  selectedValueBinding="divergenceGroupBy@divergingStatements@defaultBean@servletRequest">
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_GROUPBY_NONE@defaultBundle@servletRequest"
                    value="none"/>
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_ATTR_ERROR_OBSERVED@defaultBundle@servletRequest"
                    value="errorObserved"/>
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_ATTR_SQL_ID@defaultBundle@servletRequest"
                    value="sqlId"/>
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_ATTR_SESSION@defaultBundle@servletRequest"
                    value="session"/>
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_ATTR_SERVICE@defaultBundle@servletRequest"
                    value="service"/>
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_ATTR_MODULE@defaultBundle@servletRequest"
                    value="module"/>
                  <uix:option
                    textBinding="REPLAY_DIVERGENCE_ATTR_ACTION@defaultBundle@servletRequest"
                    value="action"/>
                </uix:messageChoice>
                </uix:labeledFieldLayout>
              </uix:stackLayout>
            </uix:header>

            <uix:spacer width="1" height="5"/>

            <uix:rowLayout>
              <uix:submitButton
                textBinding="FETCH_DIVERGING_CALLS@defaultBundle@servletRequest"
                event="queryDivergenceDetails"/>
            </uix:rowLayout>

          </uix:hideShowHeader>

          <uix:separator/>

          <uix:header
            textBinding="DIVERGING_CALLS_HEADER@defaultBundle@servletRequest">
            <uix:stackLayout>
              <uix:styledText
                textBinding="replayDivergenceDetailsTableExplained@divergingStatements@defaultBean@servletRequest"
                styleClass="OraInstructionText"/>
              <uix:spacer width="1" height="5"/>
              <uix:tip>
                <uix:styledText
                  textBinding="REPLAY_DIVERGING_CALL_DRILLDOWN_TIP@defaultBundle@servletRequest"/>
              </uix:tip>
              <uix:spacer width="1" height="5"/>

              <%-- Table of Replay Divergence Details --%>
              <uix:switcher
                childNameBinding="divergenceGroupBy@divergingStatements@defaultBean@servletRequest">
                <uix:case name="none">

                  <%-- Non-grouped diverging calls --%>
                  <oem:table
                    id="replayDivergingStatementsTable"
                    name="replayDivergingStatementsTable"
                    beanKey="defaultBean"
                    dataSourceProp="divergingStatements"
                    formSubmitted="true"
                    width="90%"
                    blockSizeBinding="blockSize@divergingStatements@defaultBean@servletRequest"
                    partialRenderMode="self"
                    summaryBinding="summary@divergingStatements@defaultBean@servletRequest"
                    alternateTextBinding="REPLAY_DIVERGENCE_ALL_CALLS_FILTERED@defaultBundle@servletRequest">
                    <uix:tableActions>
                      <uix:flowLayout>
                        <uix:button
                          textBinding="LOAD_VISIBLE_DIVERGING_CALLS@defaultBundle@servletRequest"
                          destinationBinding="loadVisibleCallsDest@divergingStatements@defaultBean@servletRequest"
                          disabledBinding="everyVisibleCallLoaded@divergingStatements@defaultBean@servletRequest"/>
                      </uix:flowLayout>
                    </uix:tableActions>
                  </oem:table>

                </uix:case>
                <uix:default>

                  <uix:dataScope
                    currentDataBinding="divergingStatements@defaultBean@servletRequest">
                    <%-- Grouped diverging calls --%>
                    <uix:table
                      id="groupedDivergenceDetailsTable"
                      name="groupedDivergenceDetailsTable"
                      formSubmitted="true"
                      showAll="yes"                       
                      width="90%"
                      columnHeaderDataBinding="columnData@divergingStatements@defaultBean@servletRequest"
                      columnFormatsBinding="columnData@divergingStatements@defaultBean@servletRequest"
                      blockSize="10"
                      valueBinding="indexOfFirstVisibleRow@divergingStatements@defaultBean@servletRequest"
                      maxValueBinding="rowCount@divergingStatements@defaultBean@servletRequest"
                      tableDataBinding="tableData@divergingStatements@defaultBean@servletRequest"
                      allDetailsEnabled="false"
                      detailDisclosureBinding="detailDisclosure@divergingStatements@defaultBean@servletRequest">

                      <%-- table of individual calls --%>
                      <uix:detail>
                        <uix:header
                          textBinding="detailHeaderText">

                          <uix:include nodeBinding="detailTableUINode"/>
                          <%--
                          <oem:table
                            id="divergingStatementsInGroupTable_N"
                            name="divergingStatementsInGroupTable_N"
                            dataSourceBinding="detailTableDataSource"
                            formSubmitted="true"
                            width="100%"
                            blockSizeBinding="blockSize@divergingStatements@defaultBean@servletRequest"
                            summaryBinding="detailHeaderText"
                            alternateTextBinding="REPLAY_DIVERGENCE_ALL_CALLS_FILTERED@defaultBundle@servletRequest">
                            <uix:tableActions>
                              <uix:flowLayout>
                                <uix:button
                                  textBinding="LOAD_VISIBLE_DIVERGING_CALLS@defaultBundle@servletRequest"
                                  destinationBinding="loadVisibleCallsDest@divergingStatements@defaultBean@servletRequest"
                                  disabledBinding="everyVisibleCallLoaded@divergingStatements@defaultBean@servletRequest"/>
                              </uix:flowLayout>
                            </uix:tableActions>
                          </oem:table>
                            --%>

                          <uix:spacer width="100" height="5"/>

                        </uix:header>
                      </uix:detail>

                      <%-- grouping attribute column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                             textBinding="text"
                             sortableBinding="sortable"
                             value="0"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="groupingAttributeValue">
                          <uix:end>
                            <uix:flowLayout
                              renderedBinding="errorMessageRendered">
                              <uix:spacer width="3"/>
                              <uix:image
                                sourceBinding="infoIcon@defaultBean@servletRequest"
                                shortDescBinding="errorMessageValue"/>
                            </uix:flowLayout>
                          </uix:end>
                        </uix:messageStyledText>
                      </uix:column>

                      <%-- error message column --%>
                      <uix:column rendered="false">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortable="no"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="errorMessageValue"/>
                      </uix:column>

                      <%-- thread failure column --%>
                      <uix:column renderedBinding="threadFailureRendered">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="2"/>
                        </uix:columnHeader>
                        <uix:image
                          sourceBinding="threadFailureSource"
                          shortDescBinding="threadFailureShortDesc"/>
                      </uix:column>

                      <%-- count star column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="3"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="countStarValue"/>
                      </uix:column>

                      <%-- count all column --%>
                      <uix:column renderedBinding="countAllRendered">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="4"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="countAllValue"/>
                      </uix:column>

                      <%-- first error column --%>
                      <uix:column renderedBinding="firstErrorRendered">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="5"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="firstErrorValue"/>
                      </uix:column>

                      <%-- last error column --%>
                      <uix:column renderedBinding="lastErrorRendered">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="6"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="lastErrorValue"/>
                      </uix:column>

                      <%-- count distinct column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="7"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="countDistinctValue"/>
                      </uix:column>

                      <%-- dml magnitude column --%>
                      <uix:column renderedBinding="dmlMagnitudeRendered">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="8"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="dmlMagnitudeValue"/>
                      </uix:column>

                      <%-- query magnitude column --%>
                      <uix:column renderedBinding="queryMagnitudeRendered">
                        <uix:columnHeader>
                          <uix:sortableHeader 
                            textBinding="text"
                            sortableBinding="sortable"
                            value="9"/>
                        </uix:columnHeader>
                        <uix:messageStyledText
                          textBinding="queryMagnitudeValue"/>
                      </uix:column>

                    </uix:table>
                  </uix:dataScope>
                </uix:default>
              </uix:switcher>

            </uix:stackLayout>
          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
