<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="title@divergingStatement@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,replayId,streamId,callCounter">

        <uix:formValue
          name="pageName"
          value="/database/workload/replayDivergingStatement"/>

        <uix:pageLayout
          titleBinding="pageTitle@divergingStatement@servletRequest">

          <%@ include file="/database/workload/errors.jspf" %>

          <uix:pageStatus>
            <uix:rowLayout width="100%">
              <uix:messagePrompt
                styleClass="OraInstructionText"
                promptBinding="pagePrompt@divergingStatement@servletRequest"/>
            </uix:rowLayout>
          </uix:pageStatus>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                textBinding="CLOSE@workloadBundle@servletRequest"
                shortDescBinding="CLOSE@workloadBundle@servletRequest"
                onClick="top.close()"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <%-- Call attributes --%>
          <uix:header
            textBinding="REPLAY_DIVERGING_STATEMENT_HEADER_CALL_ATTRIBUTES@defaultBundle@servletRequest">
            <uix:labeledFieldLayout columns="2" width="600">

              <uix:messageStyledText
                promptBinding="REPLAY_DIVERGENCE_ATTR_ERROR_OBSERVED@defaultBundle@servletRequest"
                shortDescBinding="REPLAY_DIVERGENCE_ATTR_ERROR_OBSERVED@defaultBundle@servletRequest"
                textBinding="observedErrorNumberFormatted@divergingStatement@servletRequest"
                styleClass="OraDataText"/>

              <uix:messageStyledText
                promptBinding="REPLAY_DIVERGENCE_ATTR_SERVICE@defaultBundle@servletRequest"
                shortDescBinding="REPLAY_DIVERGENCE_ATTR_SERVICE@defaultBundle@servletRequest"
                textBinding="service@divergingStatement@servletRequest"
                styleClass="OraDataText"/>

              <uix:messageStyledText
                promptBinding="REPLAY_DIVERGENCE_ATTR_SQL_ID@defaultBundle@servletRequest"
                shortDescBinding="REPLAY_DIVERGENCE_ATTR_SQL_ID@defaultBundle@servletRequest"
                textBinding="sqlId@divergingStatement@servletRequest"
                styleClass="OraDataText"/>

              <uix:messageStyledText
                promptBinding="REPLAY_DIVERGENCE_ATTR_MODULE@defaultBundle@servletRequest"
                shortDescBinding="REPLAY_DIVERGENCE_ATTR_MODULE@defaultBundle@servletRequest"
                textBinding="module@divergingStatement@servletRequest"
                styleClass="OraDataText"/>

              <uix:messageStyledText
                promptBinding="REPLAY_DIVERGENCE_PROMPT_SESSION@defaultBundle@servletRequest"
                shortDescBinding="REPLAY_DIVERGENCE_PROMPT_SESSION@defaultBundle@servletRequest"
                textBinding="session@divergingStatement@servletRequest"
                styleClass="OraDataText"/>

              <uix:messageStyledText
                promptBinding="REPLAY_DIVERGENCE_ATTR_ACTION@defaultBundle@servletRequest"
                shortDescBinding="REPLAY_DIVERGENCE_ATTR_ACTION@defaultBundle@servletRequest"
                textBinding="action@divergingStatement@servletRequest"
                styleClass="OraDataText"/>

            </uix:labeledFieldLayout>
          </uix:header>

          <uix:separator/>

          <%-- Full SQL Text Value --%>
          <uix:hideShowHeader
            id="fullSqlTextHideShow"
            textBinding="REPLAY_DIVERGING_STATEMENT_HEADER_SQL_STATEMENT_TEXT@defaultBundle@servletRequest"
            disclosedBinding="fullSqlTextDisclosed@divergingStatement@servletRequest"
            formSubmitted="true"/>
          <uix:rowLayout>
            <uix:spacer width="20" height="1"/>
            <db:sqlDisplay
              sqlListBinding="sqlTextComponents@divergingStatement@servletRequest"/>
          </uix:rowLayout>

          <%-- List of Bind Variables --%>
          <uix:header
            textBinding="REPLAY_DIVERGING_STATEMENT_HEADER_SQL_BIND_VARIABLES@defaultBundle@servletRequest"
            renderedBinding="bindsNonempty@divergingStatement@servletRequest">
            <uix:messageChoice
              name="iterationId"
              promptBinding="EXECUTION_ITERATION@defaultBundle@servletRequest"
              shortDescBinding="EXECUTION_ITERATION@defaultBundle@servletRequest"
              selectedValueBinding="iterationId@divergingStatement@servletRequest"
              onChange="submitForm('form',1,{'event':'refresh'})"
              readOnlyBinding="iterationIdReadOnly@divergingStatement@servletRequest">
              <uix:contents
                childDataBinding="iterationIds@divergingStatement@servletRequest">
                <uix:option
                  textBinding="textKey"
                  valueBinding="valueKey"
                  shortDescBinding="textKey"/>
              </uix:contents>
            </uix:messageChoice>
            <uix:stackLayout
              renderedBinding="iterationOverflow@divergingStatement@servletRequest">
              <uix:spacer height="5"/>
              <uix:tip
                textBinding="EXECUTION_ITERATION_OVERFLOW@defaultBundle@servletRequest"/>
            </uix:stackLayout>
            <uix:spacer height="10"/>
            <uix:labeledFieldLayout
              labelWidth="5%"
              fieldWidth="95%"
              width="80%">
              <uix:contents
                childDataBinding="binds@divergingStatement@servletRequest">
                <uix:messageStyledText
                  promptBinding="bindName"
                  textBinding="bindValue"
                  styleClass="OraDataText"/>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
