<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="replayExternalInteractionPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post"
        copyParams="target,type,cancelURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/replayExternalInteraction"/>

        <uix:pageLayout
          titleBinding="replayExternalInteractionPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
            <uix:stackLayout>
              <oem:messageBox
                 messageTypeBinding="messageType@servletRequest"
                 errorTableBinding="errors@servletRequest"
                 destTableBinding="msgUrls@servletRequest"
                 titleTextKey="titleText"
                 mainTextKey="mainText"/>
              <uix:spacer height="10"/>
              <uix:hideShow
                id="warningIsolatedEnvironment"
                partialRenderMode="self"
                formSubmitted="true"
                disclosedBinding="showWarningIsolatedEnvironment@defaultBean@servletRequest"
                disclosedTextBinding="ATTENTION_ISOLATED_ENVIRONMENT@defaultBundle@servletRequest"
                undisclosedTextBinding="ATTENTION_ISOLATED_ENVIRONMENT@defaultBundle@servletRequest">
                <uix:contents>
                  <uix:messageBox
                    messageType="warning"
                    messageBinding="PROMPT_ISOLATED_ENVIRONMENT@defaultBundle@servletRequest"
                    styleClass="OraMessageBoxText">
                    <uix:styledText
                      textBinding="WARNING_ISOLATED_ENVIRONMENT@defaultBundle@servletRequest"
                      styleClass="OraMessageBoxText"/>
                  </uix:messageBox>
                </uix:contents>
              </uix:hideShow>
              <uix:spacer height="10"/>
            </uix:stackLayout>
          </uix:messages>

          <uix:pageStatus>
            <uix:rowLayout width="100%">
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="PROMPT_EXTERNAL_INTERACTION@defaultBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:pageStatus>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                textBinding="CANCEL@DBObjectBundle@servletRequest"
                shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton
                textBinding="CONTINUE@DBObjectBundle@servletRequest"
                shortDescBinding="CONTINUE@DBObjectBundle@servletRequest"
                name="event"
                value="start"/>
<%--
              <uix:submitButton
                textBinding="OK@DBObjectBundle@servletRequest"
                shortDescBinding="OK@DBObjectBundle@servletRequest"
                name="event"
                value="replay"/>
--%>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:spacer height="15"/>
<%--
          <%@ include file="/database/workload/externalInteractionTabs.jspf" %>
--%>

          <uix:styledText
            textBinding="PROMPT_EXTERNAL_INTERACTION_VERIFY@defaultBundle@servletRequest"
            styleClass="OraInstructionText"/>

          <uix:bulletedList>
            <uix:flowLayout>
              <uix:link
                textBinding="DATABASE_LINKS@DBMsgBundle@servletRequest"
                shortDescBinding="DATABASE_LINKS@DBMsgBundle@servletRequest"
                destinationBinding="databaseLinksDest@defaultBean@servletRequest"/>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="HYPHEN@workloadBundle@servletRequest"
                styleClass="OraInstructionText"/>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="PROMPT_LINK_OUTSIDE@defaultBundle@servletRequest"
                styleClass="OraInstructionText"/>
            </uix:flowLayout>
            <uix:flowLayout>
              <uix:link
                textBinding="DIRECTORY_OBJECTS@DBMsgBundle@servletRequest"
                shortDescBinding="DIRECTORY_OBJECTS@DBMsgBundle@servletRequest"
                destinationBinding="directoryObjectsDest@defaultBean@servletRequest"/>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="HYPHEN@workloadBundle@servletRequest"
                styleClass="OraInstructionText"/>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="PROMPT_LINK_OUTSIDE@defaultBundle@servletRequest"
                styleClass="OraInstructionText"/>
            </uix:flowLayout>
            <uix:flowLayout>
              <uix:link
                textBinding="STREAMS@DBMsgBundle@servletRequest"
                shortDescBinding="STREAMS@DBMsgBundle@servletRequest"
                destinationBinding="streamsDest@defaultBean@servletRequest"/>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="HYPHEN@workloadBundle@servletRequest"
                styleClass="OraInstructionText"/>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="PROMPT_LINK_OUTSIDE@defaultBundle@servletRequest"
                styleClass="OraInstructionText"/>
            </uix:flowLayout>
          </uix:bulletedList>

          <uix:spacer height="10"/>
          <uix:tip
            textBinding="PROMPT_MORE_EXTERNAL_INTERACTIONS@defaultBundle@servletRequest"/>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
