<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body
      onLoad="document.getElementById('previousReplay').disabled=!document.getElementById('initialOptionsPrevious').checked;">
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/replayInitialOptions"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:spacer height="10"/>

<%--
          <uix:header
            textBinding="REPLAY_NAME@workloadBundle@servletRequest">
            <uix:stackLayout>

              <uix:styledText
                textBinding="PROMPT_REPLAY_NAME@defaultBundle@servletRequest"
                styleClass="OraInstructionText"/>
  
              <uix:spacer height="10"/>
--%>
  
              <uix:labeledFieldLayout fieldWidth="99%">
                  <uix:messageTextInput
                    name="replayName"
                    promptBinding="REPLAY_NAME@workloadBundle@servletRequest"
                    shortDescBinding="REPLAY_NAME@workloadBundle@servletRequest"
                    textBinding="replayName@defaultBean@servletRequest"
                    messageBinding="replayNameMessage@defaultBean@servletRequest"
                    messageTypeBinding="replayNameMessageType@defaultBean@servletRequest"
                    noAutoComplete="true"
                    columns="40"
                    maximumLength="64"
                    required="uiOnly"/>
<%--
                  <uix:spacer height="5"/>
  
                  <uix:messageTextInput
                    name="replayComment"
                    promptBinding="COMMENT@workloadBundle@servletRequest"
                    shortDescBinding="COMMENT@workloadBundle@servletRequest"
                    textBinding="replayComment@defaultBean@servletRequest"
                    noAutoComplete="true"
                    rows="3"
                    columns="40"
                    maximumLength="256"/>
--%>
              </uix:labeledFieldLayout>

<%--
            </uix:stackLayout>
          </uix:header>
--%>

          <uix:spacer height="10"/>
  
          <uix:header
            textBinding="IDENTIFY_SOURCE@defaultBundle@servletRequest">
            <uix:stackLayout>

              <uix:styledText
                textBinding="PROMPT_INITIAL_OPTIONS@defaultBundle@servletRequest"
                styleClass="OraInstructionText"/>
  
              <uix:spacer height="10"/>

              <oem:radioButton
                name="initialOptions"
                selectedValueBinding="initialOptions@defaultBean@servletRequest"
                textBinding="TEXT_DEFAULT_INITIAL_OPTIONS@defaultBundle@servletRequest"
                onClick="document.getElementById('previousReplay').disabled=true;"
                value="DEFAULT"/>
    
              <oem:radioButton
                id="initialOptionsPrevious"
                name="initialOptions"
                selectedValueBinding="initialOptions@defaultBean@servletRequest"
                textBinding="TEXT_PREVIOUS_INITIAL_OPTIONS@defaultBundle@servletRequest"
                disabledBinding="noPreviousReplays@defaultBean@servletRequest"
                onClick="document.getElementById('previousReplay').disabled=false;"
                value="PREVIOUS"/>

              <uix:spacer height="5"/>

              <uix:rowLayout>
                <uix:spacer width="20"/>
<%--
                <uix:choice
                  name="previousReplay"
                  id="previousReplay"
                  shortDescBinding="PREVIOUS_REPLAY@defaultBundle@servletRequest"
                  selectedValueBinding="previousReplay@defaultBean@servletRequest"
                  onChange="submitForm(\'form\',1,{\'event\':\'switchPreviousReplayOptions\'})"
                  disabledBinding="noPreviousReplays@defaultBean@servletRequest">
                  <uix:contents
                    childDataBinding="previousReplays@defaultBean@servletRequest">
                    <uix:option
                      textBinding="textKey"
                      valueBinding="valueKey"/>
                  </uix:contents>
                </uix:choice>
--%>
                <uix:messageChoice
                  id="previousReplay"
                  name="previousReplay"
                  promptBinding="REPLAY_NAME@workloadBundle@servletRequest"
                  shortDescBinding="PREVIOUS_REPLAY@defaultBundle@servletRequest"
                  selectedValueBinding="previousReplay@defaultBean@servletRequest">
                  <uix:contents
                    childDataBinding="previousReplays@defaultBean@servletRequest">
                    <uix:option
                      textBinding="textKey"
                      valueBinding="valueKey"/>
                  </uix:contents>
                </uix:messageChoice>
              </uix:rowLayout>

<%--
              <uix:spacer height="10"/>

              <%@ include file="/database/workload/replayInfoTabs.jspf" %>
--%>

            </uix:stackLayout>

          </uix:header>

        </uix:pageLayout>

      </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
