<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/replayPrepareClients"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:flowLayout>
            <uix:styledText
              textBinding="PROMPT_CLIENTS_SETUP@defaultBundle@servletRequest"
              styleClass="OraInstructionText"/>
            <uix:spacer width="5"/>
<%--
            <uix:link
              textBinding="DOCUMENTATION_REPLAY_CLIENT@defaultBundle@servletRequest"
              onClickBinding="DOCUMENTATION_REPLAY_CLIENT@defaultBundle@servletRequest"/>
--%>
            <uix:styledText
              textBinding="DOCUMENTATION_REPLAY_CLIENT@defaultBundle@servletRequest"
              styleClass="OraInstructionText"/>
          </uix:flowLayout>

          <uix:spacer height="10"/>
          
          <uix:styledText
            textBinding="PROMPT_CLIENTS_START@defaultBundle@servletRequest"
            styleClass="OraInstructionText"/>

        </uix:pageLayout>

      </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
