<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="replayPrerequisitesPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post"
        copyParams="target,type,cancelURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/replayPrerequisites"/>

        <uix:pageLayout
          titleBinding="replayPrerequisitesPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/workload/errors.jspf" %>

          <uix:pageStatus>
            <uix:rowLayout width="100%">
              <uix:styledText styleClass="OraInstructionText"
                textBinding="PROMPT_PREREQUISITES@defaultBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:pageStatus>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                textBinding="CANCEL@DBObjectBundle@servletRequest"
                shortDescBinding="CANCEL@DBObjectBundle@servletRequest"
                destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton
                textBinding="CONTINUE@DBObjectBundle@servletRequest"
                shortDescBinding="CONTINUE@DBObjectBundle@servletRequest"
                name="event"
                value="replay"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:stackLayout>
            <uix:header
              textBinding="RESTORE_DATABASE@defaultBundle@servletRequest">
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="PROMPT_RESTORE_DATABASE@defaultBundle@servletRequest"/>
            </uix:header>

            <uix:header
              textBinding="PERFORM_SYSTEM_CHANGES@defaultBundle@servletRequest">
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="PROMPT_PERFORM_SYSTEM_CHANGES@defaultBundle@servletRequest"/>
            </uix:header>
              
            <uix:header
              textBinding="RESOLVE_EXTERNAL_REFERENCES@defaultBundle@servletRequest">
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="PROMPT_RESOLVE_EXTERNAL_REFERENCES@defaultBundle@servletRequest"/>
            </uix:header>

<%--
            <uix:spacer height="5"/>

            <uix:rowLayout>
              <uix:flowLayout>
                <uix:messagePrompt
                  styleClass="OraInstructionTextStrong"
                  messageType="warning"
                  promptBinding="WARNING_RESOLVE_EXTERNAL_REFERENCES@defaultBundle@servletRequest"/>
                <uix:spacer width="5"/>
                <uix:link
                  textBinding="LINK_CAPTURED_REFERENCES@defaultBundle@servletRequest"
                  destinationBinding="capturedReferencesDest@defaultBean@servletRequest"/>
              </uix:flowLayout>
            </uix:rowLayout>
--%>

            <uix:header
              textBinding="SET_UP_REPLAY_CLIENTS@defaultBundle@servletRequest">
              <uix:flowLayout>
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="PROMPT_SET_UP_REPLAY_CLIENTS@defaultBundle@servletRequest"/>
                <uix:spacer width="5"/>
<%--
                <uix:link
                  textBinding="DOCUMENTATION_MORE_INFO@workloadBundle@servletRequest"
                  onClickBinding="DOCUMENTATION_MORE_INFO@workloadBundle@servletRequest"/>
--%>
                <uix:styledText
                  textBinding="DOCUMENTATION_MORE_INFO@workloadBundle@servletRequest"
                  styleClass="OraInstructionText"/>
              </uix:flowLayout>
            </uix:header>
          </uix:stackLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
