<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/replayReview"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:messageBox
            messageBinding="promptClockResetTime@defaultBean@servletRequest"
            messageType="info"
            styleClass="OraInstructionTextStrong">
            <uix:messagePrompt
              promptBinding="PROMPT_CLOCK_RESET@defaultBundle@servletRequest"/>
          </uix:messageBox>

          <uix:spacer height="10"/>

          <uix:styledText
            textBinding="promptReview@defaultBean@servletRequest"
            styleClass="OraInstructionText"/>

          <uix:spacer height="10"/>

          <uix:labeledFieldLayout>
            <uix:messageStyledText
              promptBinding="DATABASE@DBObjectBundle@servletRequest"
              shortDescBinding="DATABASE@DBObjectBundle@servletRequest"
              textBinding="targetName@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="CAPTURE_NAME@workloadBundle@servletRequest"
              shortDescBinding="CAPTURE_NAME@workloadBundle@servletRequest"
              textBinding="captureName@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="REPLAY_NAME@workloadBundle@servletRequest"
              shortDescBinding="REPLAY_NAME@workloadBundle@servletRequest"
              textBinding="replayName@defaultBean@servletRequest"
              styleClass="OraDataText"/>
    
            <uix:messageStyledText
              promptBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
              shortDescBinding="DIRECTORY_OBJECT@workloadBundle@servletRequest"
              textBinding="replayDirectory@defaultBean@servletRequest"
              styleClass="OraDataText"/>

            <uix:messageStyledText
              promptBinding="CONNECTED_REPLAY_CLIENTS@defaultBundle@servletRequest"
              shortDescBinding="CONNECTED_REPLAY_CLIENTS@defaultBundle@servletRequest"
              textBinding="numberOfReplayClients@defaultBean@servletRequest"
              styleClass="OraDataText"/>
          </uix:labeledFieldLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
