<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/replayWaitClients"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">
          <%@ include file="/database/workload/train.jspf" %>

          <uix:styledText
            textBinding="PROMPT_CLIENTS_START_NOW@defaultBundle@servletRequest"
            styleClass="OraInstructionTextStrong"/>

          <uix:spacer height="10"/>
          
          <uix:styledText
            textBinding="PROMPT_CLIENTS_PROCEED@defaultBundle@servletRequest"
            styleClass="OraInstructionText"/>

          <uix:spacer height="20"/>

          <uix:processing timeInterval="<%=processingPageInterval%>">
            <uix:switcher childNameBinding="replayClientConnected@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:flowLayout>
                  <%-- TODO: Connected as shortDesc --%>
                  <uix:image
                    sourceBinding="processCheckIcon@defaultBean@servletRequest"
                    shortDescBinding="YES@workloadBundle@servletRequest"/>
                  <uix:styledText
                    textBinding="PROMPT_CLIENTS_CONTINUE@defaultBundle@servletRequest"
                    styleClass="OraProcessingStatusFixed"/>
                </uix:flowLayout>
              </uix:case>
              <uix:default>
                <uix:styledText
                  textBinding="PROMPT_CLIENTS_WAITING@defaultBundle@servletRequest"
                  styleClass="OraProcessingStatusFixed"/>
              </uix:default>
            </uix:switcher>
          </uix:processing>

          <uix:spacer height="10"/>

          <uix:messageStyledText
            messageType="warning"
            styleClass="OraTipText"
            textBinding="TIP_WAIT_CLIENT@defaultBundle@servletRequest"/>

          <uix:spacer height="10"/>

          <%@ include file="/database/workload/replayClientConnections.jspf" %>
        </uix:pageLayout>

      </db:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
