<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="confirmRestartPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post"
        copyParams="target,type">
        <uix:formValue
          name="pageName"
          value="/database/workload/restartDatabaseConfirmation"/>

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/workload/errors.jspf" %>

          <uix:spacer height="5"/>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton
                textBinding="NO@DBObjectBundle@servletRequest"
                shortDescBinding="NO@DBObjectBundle@servletRequest"
                name="event" value="cancelRestart"/>
              <uix:submitButton
                textBinding="YES@DBObjectBundle@servletRequest"
                shortDescBinding="YES@DBObjectBundle@servletRequest"
                name="event" value="confirmRestart"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

          <uix:header
            messageType="confirmation"
            textBinding="confirmRestartPageHeader@defaultBean@servletRequest">

            <uix:stackLayout>

              <uix:styledText
                styleClass="OraInstructionTextStrong"
                textBinding="RESTART_DATABASE_NOW@defaultBundle@servletRequest"/>
  
              <uix:spacer height="10"/>
  
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="OPERATION_OK@defaultBundle@servletRequest"/>

            </uix:stackLayout>

          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
