<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="restartProgressPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="get"
        copyParams="target,type">
        <uix:formValue
          name="pageName"
          value="/database/workload/restartDatabaseProgress"/>

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
            <uix:stackLayout>
              <oem:messageBox
                messageTypeBinding="messageType@servletRequest"
                errorTableBinding="errors@servletRequest"
                destTableBinding="msgUrls@servletRequest"
                titleTextKey="titleText"
                mainTextKey="mainText"/>
  
              <uix:switcher childNameBinding="jobStatusMessageRendered@servletRequest">
                <uix:case name="true">
                  <uix:messageBox
                    messageType="confirmation"
                    messageBinding="jobStatusMessage@servletRequest">
                    <uix:stackLayout>
                      <uix:rowLayout>
                        <uix:link
                          textBinding="VIEW_JOB@workloadBundle@servletRequest"
                          destinationBinding="jobSummaryDest@servletRequest"/>
                      </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:messageBox>
                </uix:case>
              </uix:switcher>
            </uix:stackLayout>
          </uix:messages>

          <uix:spacer height="5"/>

          <uix:header
            textBinding="restartProgressPageHeader@defaultBean@servletRequest">

            <uix:spacer width="0" height="20"/>

            <uix:stackLayout>

              <uix:styledText
                styleClass="OraProcessingStatusFixed"
                textBinding="RESTART_DATABASE_PROGRESS@defaultBundle@servletRequest"/>
              <uix:spacer height="10"/>
              <uix:tableLayout width="100%">
                <uix:rowLayout hAlign="right">
                  <uix:submitButton
                    textBinding="REFRESH@DBObjectBundle@servletRequest"
                    shortDescBinding="REFRESH@DBObjectBundle@servletRequest"
                    name="event" value="refreshRestart"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:spacer height="10"/>

              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_RESTART_INSTRUCTION_1@defaultBundle@servletRequest"/>
              <uix:spacer height="10"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_RESTART_INSTRUCTION_2@defaultBundle@servletRequest"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_CAPTURE_STEP_1@defaultBundle@servletRequest"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_CAPTURE_STEP_2@defaultBundle@servletRequest"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_CAPTURE_STEP_3@defaultBundle@servletRequest"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_CAPTURE_STEP_4@defaultBundle@servletRequest"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="AFTER_CAPTURE_STEP_5@defaultBundle@servletRequest"/>

            </uix:stackLayout>

          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
