<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript">
function lovSelect(lovField)
{
    var proxy = new TableProxy('schemaDataSource');
    var selectedIndex = proxy.getSelectedRow();

    if (selectedIndex >= 0)
    {
        var selectedElement = proxy.getFormElement('Hidden', selectedIndex);
        lovField.value = selectedElement.value;
        window.close();
    }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:metaContainer>
      <uix:head
        titleBinding="SEARCH_AND_SELECT_HEADER@DBObjectBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@odefaultBean@servletRequest"
        method="post" copyParams="target,type">

        <uix:formValue name="pageName"
          value="/database/workload/searchSchema"/>

        <uix:pageLayout
          titleBinding="SEARCH_AND_SELECT_SCHEMA@DBObjectBundle@servletRequest">

          <%@ include file="/database/workload/errors.jspf" %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button
                textBinding="CANCEL@DBObjectBundle@servletRequest"
                onClick="top.close()"/>
              <uix:button
                textBinding="SELECT@DBObjectBundle@servletRequest"
                destinationBinding="selectSchemaDestination@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:tableLayout cellSpacing="2">
            <uix:rowLayout>
	      <uix:stackLayout>
	        <uix:header
                  textBinding="SEARCH@DBObjectBundle@servletRequest">
	          <uix:rowLayout>
	            <uix:messageTextInput
                      id="schemaSearchCriteria"
                      name="schemaSearchCriteria" 
                      promptBinding="SEARCH_FOR_SCHEMA@DBObjectBundle@servletRequest"
                      shortDescBinding="SEARCH_FOR_SCHEMA@DBObjectBundle@servletRequest"
                      textBinding="schemaSearchCriteria@objectBean@servletRequest"
                      enterClientActionBinding="changeSchemaSearchCriteriaAction@objectBean@servletRequest"/>
	            <uix:submitButton
                      textBinding="GO@DBObjectBundle@servletRequest"
                      name="event" 
                      value="changeSchemaSearchCriteria"/>
	          </uix:rowLayout>
	        </uix:header>
	      </uix:stackLayout>
	    </uix:rowLayout>

            <uix:rowLayout>
              <uix:stackLayout>
                <uix:header
                  textBinding="RESULT@DBObjectBundle@servletRequest">
                  <oem:table
                    name="schemaDataSource"
                    beanKey="objectBean"
                    blockSize="10"
                    formSubmitted="true"
                    dataSourceProp="schemaDataSource"
                    width="90%" 
                    summaryBinding="RESULT@DBObjectBundle@servletRequest"
                    alternateTextBinding="NO_ITEMS_FOUND@DBObjectBundle@servletRequest">
                    <uix:tableSelection>
                      <uix:singleSelection
                        shortDescBinding="SELECT_A_VALUE@DBObjectBundle@servletRequest"
                        selectedIndex="0"/>
                    </uix:tableSelection>
                  </oem:table>
	        </uix:header>
	      </uix:stackLayout>
	    </uix:rowLayout>
          </uix:tableLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

