<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="selectSchemaPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,reportType,returnURL,cancelURL">

        <uix:formValue name="pageName"
          value="/database/workload/selectSchema"/>

        <uix:pageLayout
          titleBinding="selectSchemaPageHeader@defaultBean@servletRequest">
          <%@ include file="/database/global.jspf" %>
          <%@ include file="/database/workload/errors.jspf" %>

          <uix:pageStatus>
            <uix:rowLayout>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="WHY_SCHEMA@workloadBundle@servletRequest"/>
            </uix:rowLayout>
          </uix:pageStatus>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@sdkBundle@servletRequest" 
                destinationBinding="returnURL@servletRequest"
                shortDescBinding="CANCEL@sdkBundle@servletRequest"/>
              <uix:submitButton
                textBinding="IMPORT_AWR_DATA@workloadBundle@servletRequest"
                shortDescBinding="IMPORT_AWR_DATA@workloadBundle@servletRequest"
                name="event"
                value="importAwr"
                formName="form"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:spacer height="10"/>

          <uix:rowLayout width="35%">
            <uix:stackLayout>
              <uix:labeledFieldLayout>
                <uix:messageLovField
                  name="schemaName"
                  promptBinding="SCHEMA@workloadBundle@servletRequest"
                  shortDescBinding="SCHEMA@workloadBundle@servletRequest"
                  textBinding="schemaName@reportBean@servletRequest"
                  onClickBinding="schemaURL@servletRequest"
                  searchDescBinding="SELECT_SCHEMA@workloadBundle@servletRequest"
                  required="uiOnly"/>

                <uix:spacer height="5"/>

                <uix:messageCheckBox
                  name="removeAwrDataFirst"
                  value="true"
                  selectedValueBinding="removeAwrDataFirst@reportBean@servletRequest"
                  textBinding="REMOVE_AWR_DATA_FIRST@workloadBundle@servletRequest"
                  shortDescBinding="REMOVE_AWR_DATA_FIRST@workloadBundle@servletRequest"/>
              </uix:labeledFieldLayout>
            </uix:stackLayout>
          </uix:rowLayout>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
