<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%@ page import="oracle.sysman.emo.util.workload.WorkloadConstants" %>

<script language="JavaScript">
function viewReport()
{
    var reportUrl = '<%=request.getAttribute("reportURL") == null ? "" : request.getAttribute("reportURL")%>';

    if (reportUrl.length > 0)
    {
        window.open(reportUrl, '_blank',
            'status=no, toolbar=no, location=no, menubar=no, directories=no, resizable=yes, scrollbars=yes');
        submitForm('form', true, { event: 'callback' });
    }
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="viewReplayDetailsPageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="viewReport();">
      <db:form
        name="form"
        destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type,cancelURL">

        <uix:formValue
          name="pageName"
          value="/database/workload/viewReplayDetails"/>

        <uix:pageLayout>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
            <uix:stackLayout>
              <oem:messageBox
                messageTypeBinding="messageType@servletRequest"
                errorTableBinding="errors@servletRequest"
                destTableBinding="msgUrls@servletRequest"
                titleTextKey="titleText"
                mainTextKey="mainText"/>
  
              <uix:switcher childNameBinding="jobStatusMessageRendered@servletRequest">
                <uix:case name="true">
                  <uix:messageBox
                    messageType="confirmation"
                    messageBinding="jobStatusMessage@servletRequest">
                 </uix:messageBox>
                </uix:case>
              </uix:switcher>
            </uix:stackLayout>
          </uix:messages>

          <uix:switcher
            childNameBinding="replayActive@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:switcher
                childNameBinding="refreshChoice@defaultBean@servletRequest">
                <uix:case name="RT_15">
                  <uix:rawText>
                    <meta http-equiv="Refresh" content="15">
                  </uix:rawText>
                </uix:case>
                <uix:case name="RT_60">
                  <uix:rawText>
                    <meta http-equiv="Refresh" content="60">
                  </uix:rawText>
                </uix:case>
              </uix:switcher>
            </uix:case>
          </uix:switcher>

          <uix:switcher
            childNameBinding="replayActive@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:spacer height="5"/>
                </uix:rowLayout>
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat>
                    <uix:styledText
                      labeledNodeId="refreshTime"
                      styleClass="OraInstructionText"
                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:choice
                      name="refreshChoice"
                      id="refreshTime"
                      onChange="submitForm('form', true, {'event':'changeRefreshChoice'})"
                      selectedValueBinding="refreshChoice@defaultBean@servletRequest">
                      <uix:option
                        textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                        value="RT_15"/>
                      <uix:option
                        textBinding="REAL_TIME_AUTO_60_SEC@workloadBundle@servletRequest"
                        value="RT_60"/>
                      <uix:option
                        textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                        value="RT_MAN"/>
                    </uix:choice>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

            </uix:case>
          </uix:switcher>

          <uix:contentFooter>
            <uix:pageButtonBar>
<%--
              <uix:switcher
                childNameBinding="replayActive@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:submitButton
                    textBinding="STOP_REPLAY@defaultBundle@servletRequest"
                    shortDescBinding="STOP_REPLAY@defaultBundle@servletRequest"
                    name="event"
                    value="stopReplay"/>
                </uix:case>
              </uix:switcher>
--%>
              <uix:button
                textBinding="OK@DBObjectBundle@servletRequest"
                shortDescBinding="OK@DBObjectBundle@servletRequest"
                destinationBinding="cancelURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:contentFooter>

          <uix:header
            textBinding="viewReplayDetailsPageHeader@defaultBean@servletRequest">
            <uix:tableLayout width="100%">
              <uix:switcher
                childNameBinding="replayActive@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                          <uix:styledText
                            styleClass="OraTipText"
                            textBinding="PAGE_REFRESHED_TIME@sdkBundle@servletRequest"/>
                          <uix:spacer width="5"/>
                          <uix:styledText
                            styleClass="OraTipLabel"
                            textBinding="lastUpdatedTime@defaultBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:cellFormat hAlign="right">
                          <uix:submitButton
                            textBinding="REFRESH@DBObjectBundle@servletRequest"
                            shortDescBinding="REFRESH@DBObjectBundle@servletRequest"
                            name="event"
                            value="refreshReplayDetails"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer height="3"/>
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
  
              <uix:rowLayout hAlign="right">
                <uix:pageButtonBar>
<%--
                  <uix:switcher
                    childNameBinding="replayActive@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:submitButton
                        textBinding="STOP_REPLAY@defaultBundle@servletRequest"
                        shortDescBinding="STOP_REPLAY@defaultBundle@servletRequest"
                        name="event"
                        value="stopReplay"/>
                    </uix:case>
                  </uix:switcher>
--%>
                  <uix:button
                    textBinding="OK@DBObjectBundle@servletRequest"
                    shortDescBinding="OK@DBObjectBundle@servletRequest"
                    destinationBinding="cancelURL@servletRequest"/>
                </uix:pageButtonBar>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:rowLayout
              width="53%"
              renderedBinding="monitoringReplay@defaultBean@servletRequest">
              <uix:labeledFieldLayout>
                <uix:messageLayout
                  promptBinding="STATUS@sdkBundle@servletRequest"
                  shortDescBinding="STATUS@sdkBundle@servletRequest"
                  vAlign="middle">
                  <uix:rowLayout vAlign="middle">
                    <uix:styledText
                      textBinding="statusFormatted@replayedWorkloadBean@servletRequest"
                      shortDescBinding="STATUS@sdkBundle@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                    <uix:switcher
                      childNameBinding="replayActive@defaultBean@servletRequest">
                      <uix:case name="true">
                        <uix:flowLayout>
                          <uix:spacer width="5"/>
                          <uix:submitButton
                            textBinding="STOP_REPLAY@defaultBundle@servletRequest"
                            shortDescBinding="STOP_REPLAY@defaultBundle@servletRequest"
                            name="event"
                            value="stopReplay"/>
                        </uix:flowLayout>
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout>
                </uix:messageLayout>
              </uix:labeledFieldLayout>
            </uix:rowLayout>

            <%@ include file="/database/workload/replaySummary.jspf" %>

            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:spacer height="20"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="20">
                </uix:cellFormat>
                <uix:cellFormat>
                  <%@ include file="/database/workload/replayInfoTabs.jspf" %>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          </uix:header>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
