<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <db:form
      name="form"
      destinationBinding="destination@defaultBean@servletRequest"
      method="post" copyParams="target,type,captureId,replayId,reportType">

      <uix:formValue
        name="pageName"
        value="/database/workload/viewWorkloadReport"/>

      <oem:messageBox
         messageTypeBinding="messageType@servletRequest"
         errorTableBinding="errors@servletRequest"
         destTableBinding="msgUrls@servletRequest"
         titleTextKey="titleText"
         mainTextKey="mainText"/>

      <uix:tableLayout
        width="100%"
        renderedBinding="workloadReportRendered@defaultBean@servletRequest">
        <uix:rowLayout hAlign="right">
          <uix:flowLayout>
            <uix:submitButton
              renderedBinding="workloadReportSaveRendered@defaultBean@servletRequest"
              textBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest" 
              shortDescBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest" 
              name="event"
              value="saveWorkloadReport"/>
            <uix:spacer width="3"/>
            <uix:button
              textBinding="OK@DBMsgBundle@servletRequest"
              shortDescBinding="OK@DBMsgBundle@servletRequest"
              onClick="top.close()"/>
          </uix:flowLayout>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:tableLayout width="100%">
        <uix:rawText
          renderedBinding="workloadReportRendered@defaultBean@servletRequest"
          textBinding="workloadReport@defaultBean@servletRequest"/> 
      </uix:tableLayout>

      <uix:tableLayout width="100%">
        <uix:switcher
          childNameBinding="workloadReportRendered@defaultBean@servletRequest">
          <uix:case name="false">
            <uix:spacer height="5"/>
          </uix:case>
        </uix:switcher>
        <uix:rowLayout hAlign="right">
          <uix:flowLayout>
            <uix:submitButton
              renderedBinding="workloadReportSaveRendered@defaultBean@servletRequest"
              textBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest" 
              shortDescBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest" 
              name="event"
              value="saveWorkloadReport"/>
            <uix:spacer width="3"/>
            <uix:button
              textBinding="OK@DBMsgBundle@servletRequest"
              shortDescBinding="OK@DBMsgBundle@servletRequest"
              onClick="top.close()"/>
          </uix:flowLayout>
        </uix:rowLayout>
      </uix:tableLayout>

    </db:form>
  </uix:document>
</uix:renderingContext>
