<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        allWorkspaces.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceHgridController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.AllWorkspaces
  -- Description: This is the central screen for workspace manager functionality.
  -- It shows all current workspaces in tree structure(uses HGrid) along with their attributes such as owner, 
  -- continually refreshed status and frozen mode.                 
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="workspacesList" method="post" destination="/console/database/workspacemgr/workspaceHgrid" copyParams="target,type,otype,objectType">
                <uix:formValue name="pageName" value="/database/workspace/allWorkspaces" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                            <uix:tableLayout width="100%" cellSpacing="2">
					          <uix:rowLayout hAlign="right">
					            <uix:cellFormat>
					              <uix:rowLayout>
					                <uix:styledText styleClass="OraTipText" 
					                     textBinding="PAGE_REFRESHED@uixDBMsgBundle"/>
						        	<uix:spacer width="5"/>
					                <uix:styledText styleClass="OraTipLabel" 
					                     textBinding="lastUpdatedTime@objectBean@servletRequest"/>
							        <uix:spacer width="10"/>
					               <!-- <uix:submitButton textBinding="REFRESH@uixDBObjectBundle"
					                     name="event" value="refresh" shortDescBinding="REFRESH@uixDBObjectBundle"/> -->
					
					              </uix:rowLayout>
					            </uix:cellFormat>
					          </uix:rowLayout>
				          </uix:tableLayout>
	                    <uix:styledText styleClass="OraInstructionText" textBinding="WORKSPACE_MANAGER_INFO@uixWorkspaceObjectBundle"  />
   	                    <uix:styledText styleClass="OraInstructionText" textBinding="WORKSPACE_MANAGER_LIVE_INFO@uixWorkspaceObjectBundle"  />
                        <uix:tableLayout width="100%">
						    <uix:contents>
						        <uix:rowLayout hAlign="right">
					          	  <uix:cellFormat>
					            	  <uix:rowLayout>					            						        
							            <uix:contents>
	   											<uix:submitButton textBinding="VERSION_ENABLED_OBJECTS@uixDBObjectBundle" shortDescBinding="VERSION_ENABLED_OBJECTS@uixDBObjectBundle" name="event" value="VERSION_ENABLED_OBJECT" />
										        <uix:spacer width="5"/>	   											
												<uix:submitButton textBinding="CREATE@uixDBObjectBundle" name="event" value="create" shortDescBinding="CREATE@uixDBObjectBundle"/>
							            </uix:contents>
						              </uix:rowLayout>
						            </uix:cellFormat>
						        </uix:rowLayout>
						    </uix:contents>
                        </uix:tableLayout>
                        <uix:tableLayout width="100%">
						    <uix:contents>
						        <uix:rowLayout >
						            <uix:contents>
										<uix:spacer width="10" height="10"/>
						            </uix:contents>
						        </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:hGrid id="workspaces" width="100%" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" destinationBinding="destination@objectBean@servletRequest" summary="ALL_WORKSPACES_SUMMARY" columnFormatsBinding="columnFormats@objectBean@servletRequest" columnHeaderDataBinding="columnHeaderData@objectBean@servletRequest" treeDataBinding="treeData@objectBean@servletRequest" proxyBinding="proxy@servletRequest">
			                                        <uix:formValue name="displayedItem" valueBinding="uniqueID"/>
													<uix:tableSelection>
								                       <uix:singleSelection selectedIndex="0"
													  
shortDescBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle">
									                         <uix:contents>
					                                           <uix:submitButton textBinding="EDIT@uixDBObjectBundle" name="event" value="edit" shortDescBinding="EDIT@uixDBObjectBundle" />	                                           
															   <uix:spacer width="5" height="5"/>
					                                           <uix:submitButton textBinding="VIEW@uixDBObjectBundle" value="view" name="event" shortDescBinding="VIEW@uixDBObjectBundle" />	                                           
   															   <uix:spacer width="5" height="5"/>					                                           
					                                           <uix:submitButton textBinding="WORKSPACE_SAVEPOINT_HDR@uixWorkspaceObjectBundle" name="event" value="WORKSPACE_SAVEPOINTS" shortDescBinding="WORKSPACE_SAVEPOINT_HDR@uixWorkspaceObjectBundle" />	                                           
															   <uix:spacer width="5" height="5"/>					                                           
					                                           <uix:submitButton textBinding="DELETE@uixDBObjectBundle" name="event" value="delete" shortDescBinding="DELETE@uixDBObjectBundle" />	                                           
				 					                           <uix:spacer width="10" height="10"/>
									                           <uix:messageChoice name="selectedOperationChoice" promptBinding="ACTIONS@uixDBObjectBundle">
																    <uix:contents childDataBinding="actionItemsList@objectBean@servletRequest">
        	                    										<uix:option textBinding="textKey" valueBinding="valueKey"/>
										       		                </uix:contents>
									       					   </uix:messageChoice>
									                           <uix:spacer width="10" height="10"/>
									                           <uix:submitButton name="event" value="operationsGo" textBinding="GO@uixDBObjectBundle" shortDescBinding="GO@uixDBObjectBundle" />
									                         </uix:contents>
									                       </uix:singleSelection>
								                     </uix:tableSelection>
								                     <uix:nodeStamp>
			                                                <uix:column>
			                                                    <uix:columnHeader>
			                                                        <uix:styledText textBinding="NAME_HEADER@uixWorkspaceObjectBundle"/>
			                                                    </uix:columnHeader>
                                                                <db:link textBinding="text"  destinationBinding="workspaceDest"  />
			                                                </uix:column>
			                                         </uix:nodeStamp>
			                                         <uix:columnHeaderStamp>
			                                                <uix:text textBinding="text" />
			                                         </uix:columnHeaderStamp>
												    <uix:styledText textBinding="description"/>
												    <uix:styledText textBinding="owner"/>
													<uix:styledText textBinding="freezeStatus"/>
												    <uix:image sourceBinding="continuallyRefreshedImage"/>
												    
                                        </uix:hGrid>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                       <uix:spacer height="10"/>      
						<uix:header textBinding="RELATED_LINKS@uixDBMsgBundle">
						  <uix:tableLayout width="100%"> 
						    <uix:rowLayout>
						        <uix:cellFormat>
							      <db:link textBinding="WORKSPACE_SYSTEM_PARAMETERS@uixWorkspaceObjectBundle"
							       destination="/console/database/workspacemgr/workspace?event=WORKSPACE_SYSTEM_PARAMETERS" copyParams="target,type,otype"/>
							    </uix:cellFormat>
						    </uix:rowLayout>
						  <uix:rowLayout>
						        <uix:cellFormat>
							      <db:link textBinding="VERSION_ENABLED_OBJECTS@uixDBObjectBundle"
									destination="/console/database/workspacemgr/versionedObject?otype=VERSION_ENABLED_OBJECT" copyParams="target,type" />
							    </uix:cellFormat> 
						    </uix:rowLayout>
						  </uix:tableLayout> 
						</uix:header>
                    </uix:contents>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
