<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        createSavepoint.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: Create savepoints
  --%>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="workspaceSavepoints" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/createSavepoint" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                        <uix:spacer height="10" width="10" />
						        <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
						            <uix:contents>
						            <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right" vAlign="top">
						                            <uix:contents>
													    <uix:messagePrompt promptBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
														    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						            
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right" vAlign="top">
						                            <uix:contents>
							                            <uix:messagePrompt promptBinding="SAVEPOINT_NAME@uixWorkspaceObjectBundle"
														id="savepointName" labeledNodeId="savepointName" required="yes"/>
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
						                                <uix:messageTextInput name="savepointName" id="savepointName"
													shortDescBinding="SAVEPOINT_NAME@uixWorkspaceObjectBundle"
labeledNodeId="savepointName" textBinding="savepointName@selSavepointObj@objectBean@servletRequest"/>	
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right" vAlign="top">
						                            <uix:contents>
						                                <uix:styledText styleClass="OraInstructionText" 
														labeledNodeId="savepointDesc" textBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" />
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
						                                <uix:messageTextInput name="savepointDesc" id="savepointDesc"
														labeledNodeId="savepointDesc"
														shortDescBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" rows="2" columns="45" textBinding="description@selSavepointObj@objectBean@servletRequest"/>	
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right" vAlign="top">
						                            <uix:contents>
						                                <uix:styledText styleClass="OraInstructionText" textBinding="TYPE_HEADER@uixWorkspaceObjectBundle" />
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
						                                <uix:styledText styleClass="OraDataText" textBinding="SAVEPOINT_EXPLICIT_TEXT@uixWorkspaceObjectBundle" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						            </uix:contents>
						        </uix:tableLayout>
                    </uix:contents>
	                <uix:pageButtons>
		          	  		<uix:pageButtonBar>
		                   	   <jsp:include page="workspaceButtonInclude.jsp" />
		                       <uix:ref refID="savepointInclude" />
		                  	</uix:pageButtonBar>
	              	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
