<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%-- Page:        enableVersioning.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/VersionedObjectController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.version.VersionEnabledObject
  -- Description: This is the central screen to enable Versioning functionality.
  --%>
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg" />
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="enableVersioningObjects" method="post" destination="/console/database/workspacemgr/versionedObject" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/enableVersioning" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
				   titleTextKey="titleText" mainTextKey="mainText" /> 
                    <uix:contents>
						<uix:header textBinding="OPTIONS@uixDBObjectBundle">
						    <uix:contents>
						        <uix:tableLayout width="100%">
						            <uix:contents>
						                <uix:rowLayout hAlign="left">
						                    <uix:contents>
						                        <uix:cellFormat width="50%" vAlign="top">
						                            <uix:contents>
						                                <uix:messageRadioSet name="versionHistoryOption" promptBinding="VERSIONING_HISTORY_OPTION_TXT@uixWorkspaceObjectBundle" selectedValueBinding="selHistoryOption@objectBean@servletRequest">
						                                    <uix:contents>
						                                        <uix:option textBinding="VERSIONING_HISTORY_OPTION_NONE@uixWorkspaceObjectBundle"  value="VERSIONING_HISTORY_OPTION_NONE"/>
						                                        <uix:option textBinding="VERSIONING_HISTORY_OPTION_WITHOVER@uixWorkspaceObjectBundle" value="VERSIONING_HISTORY_OPTION_WITHOVER" />
						                                        <uix:option textBinding="VERSIONING_HISTORY_OPTION_WITHOUTOVER@uixWorkspaceObjectBundle" value="VERSIONING_HISTORY_OPTION_WITHOUTOVER" />
						                                    </uix:contents>
						                                </uix:messageRadioSet>
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat width="50%" vAlign="top">
						                            <uix:contents>
						                                <uix:messageRadioSet name="versionTimeSupportOption" promptBinding="VERSIONING_VALID_TIME_OPTION@uixWorkspaceObjectBundle" selectedValueBinding="selValidTimeSupportTxt@objectBean@servletRequest">
						                                    <uix:contents>
						                                        <uix:option textBinding="YES@uixWorkspaceObjectBundle" value="YES" />
						                                        <uix:option textBinding="NO@uixWorkspaceObjectBundle" value="NO" />
						                                    </uix:contents>
						                                </uix:messageRadioSet>
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						            </uix:contents>
						        </uix:tableLayout>
						    </uix:contents>
						</uix:header>
						<uix:header textBinding="SELECTED_OBJECTS@uixWorkspaceObjectBundle">
						    <uix:contents>
                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:spacer height="10" width="10" />
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:table name="selectedVersionObjectTable" 
												summaryBinding="SELECTED_OBJECTS@uixWorkspaceObjectBundle"
												alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" formSubmitted="true" width="100%" tableDataBinding="rowData@selectedObjectsbean@servletRequest" blockSizeBinding="blockSize@selectedObjectsbean@servletRequest" maxValueBinding="numRows@selectedObjectsbean@servletRequest" valueBinding="startIndex@selectedObjectsbean@servletRequest">
                                                    <uix:tableFormat tableBanding="rowBanding" />
                                                    <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="SCHEMA_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiSchemaSort@selectedObjectsbean@servletRequest" />
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="objectNameFormat" width="15%" />
                                                        <uix:text textBinding="SCHEMA_HEADER" />
                                                    </uix:column>
                                                    <uix:column>
                                                        <uix:columnHeader>
                                                           	<uix:switcher childNameBinding="topologiesSelected@objectBean@servletRequest">
							                                  	<uix:case name="false">    	
		                                                            <uix:sortableHeader textBinding="TABLE_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTableNameSort@searchVersionObjectbean@servletRequest" />					    							    		
	                                                            </uix:case>
	                                                            <uix:case name="true">    	
		                                                            <uix:sortableHeader textBinding="TOPOLOGY_HDR@uixWorkspaceObjectBundle" sortableBinding="uiTableNameSort@searchVersionObjectbean@servletRequest" />					    							    		
	                                                            </uix:case>
							                                </uix:switcher>   
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="textFormat" width="20%" />
                                                        <uix:text textBinding="TABLE_HEADER" />
                                                    </uix:column>
                                                </uix:table>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
	                            <uix:messagePrompt messageType="info" promptBinding="TOPOLOGIES_INFO@uixWorkspaceObjectBundle"  renderedBinding="topologiesSelected@objectBean@servletRequest"/>
						    </uix:contents>
						</uix:header>
						<uix:switcher childNameBinding="topologiesSelected@objectBean@servletRequest">
							<uix:case name="false">    	
							<uix:header textBinding="RICSET_HDR@uixWorkspaceObjectBundle">
							    <uix:contents>
							    <uix:styledText   textBinding="RICSET_INFO@uixWorkspaceObjectBundle" styleClass="OraInstructionText" />
	                                <uix:tableLayout width="100%">
	                                    <uix:contents>
	                                        <uix:rowLayout>
	                                            <uix:contents>
	                                                <uix:spacer height="10" width="10" />
	                                            </uix:contents>
	                                        </uix:rowLayout>
	                                        <uix:rowLayout width="100%">
	                                            <uix:contents>
	                                                <uix:table name="ricSetTable"
													summaryBinding="RICSET_HDR@uixWorkspaceObjectBundle"
													 alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" formSubmitted="true" width="100%" tableDataBinding="rowData@ricSetObjectsbean@servletRequest" blockSizeBinding="blockSize@ricSetObjectsbean@servletRequest" maxValueBinding="numRows@ricSetObjectsbean@servletRequest" valueBinding="startIndex@ricSetObjectsbean@servletRequest">
	                                                    <uix:tableFormat tableBanding="rowBanding" />
	                                                    <uix:column>
	                                                        <uix:columnHeader>
	                                                            <uix:sortableHeader textBinding="SCHEMA_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiSchemaSort@ricSetObjectsbean@servletRequest" />
	                                                        </uix:columnHeader>
	                                                        <uix:columnFormat columnDataFormat="objectNameFormat" width="15%" />
	                                                        <uix:text textBinding="SCHEMA_HEADER" />
	                                                    </uix:column>
	                                                    <uix:column>
	                                                        <uix:columnHeader>
	                                                            <uix:sortableHeader textBinding="TABLE_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTableNameSort@ricSetObjectsbean@servletRequest" />
	                                                        </uix:columnHeader>
	                                                        <uix:columnFormat columnDataFormat="textFormat" width="20%" />
	                                                        <uix:text textBinding="TABLE_HEADER" />
	                                                    </uix:column>
	                                                    <uix:column>
	                                                        <uix:columnHeader>
                                                                 <uix:sortableHeader sortable="no" textBinding="INDEX_ORG_LABEL@uixWorkspaceObjectBundle" />
	                                                        </uix:columnHeader>
	                                                        <uix:columnFormat columnDataFormat="textFormat" width="20%" />
	                                                        <uix:text textBinding="isIOT" />
	                                                    </uix:column>
	                                                </uix:table>
	                                            </uix:contents>
	                                        </uix:rowLayout>
                                        </uix:contents>
	                                </uix:tableLayout>
							    </uix:contents>
							</uix:header>
                          </uix:case>
                        </uix:switcher>   
                    </uix:contents>
					<uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                   			<uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
							                  shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
							                  name="event" 
							                  value="showSql" />
							    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
							                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
							                      name="event" 
							                      value="cancel"/>
							    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
							                      shortDescBinding="OK@uixDBObjectBundle@servletRequest"
							                      name="event" 
							                      value="apply" 
                                                                              disabledBinding="DISABLE_OK@servletRequest"
                                                                 />
	                  	</uix:pageButtonBar>
	        	  	</uix:pageButtons>
	    	   </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
