<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        freezePage.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description: The screen gives overview of selected workspace.It provides following details: 
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
		<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="editWorkspaceForm" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/freezePage" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
				<uix:subTabLayout>
						<uix:subTabs>				
					        <uix:subTabBar selectedIndex="2">
							<!--Tab Code Start-->
					        <uix:contents>
					        	<uix:link textBinding="GENERAL_TAB@uixWorkspaceObjectBundle" 
										onClick="submitForm('editWorkspaceForm', true, {event:'generalTab'})"/>
					        	<uix:link textBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'privilegeTab'})"/>
								<uix:link textBinding="FREEZE_TAB@uixWorkspaceObjectBundle"/>
					        	<uix:link textBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'savepointTab'})"/>
					        	<uix:link textBinding="SESSION_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'sessionTab'})"/>
					        </uix:contents>
					       <!--Tab Code END-->
					       </uix:subTabBar>
						</uix:subTabs>					       
		                   <uix:styledText styleClass="OraInstructionText" textBinding="FREEZE_INFO@uixWorkspaceObjectBundle"  />
   					       <uix:spacer height="10" width="10" />
							<uix:tableLayout cellSpacing="5" hAlign="center" width="80%">
								    <uix:contents>
<%--  							        <uix:spacer height="10" width="10" />
								        <uix:rowLayout>
								            <uix:contents>
								                <uix:cellFormat hAlign="right">
								                    <uix:contents>
								                        <uix:styledText styleClass="OraInstructionText" textBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								                        <uix:spacer height="10" width="10" />
								                    </uix:contents>
								                </uix:cellFormat>
								                <uix:cellFormat>
								                    <uix:contents>
								                        <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />
								                    </uix:contents>
								                </uix:cellFormat>
								            </uix:contents>
								        </uix:rowLayout>
								        <uix:rowLayout>
								        <uix:rowLayout>
								            <uix:contents>
								                <uix:cellFormat hAlign="right">
								                    <uix:contents>
								                        <uix:styledText styleClass="OraInstructionText" textBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								                        <uix:spacer height="10" width="10" />
								                    </uix:contents>
								                </uix:cellFormat>
								                <uix:cellFormat>
								                    <uix:contents>
								                        <uix:styledText styleClass="OraDataText" textBinding="parentWorkspace@objectBean@servletRequest" />
								                    </uix:contents>
								                </uix:cellFormat>
								            </uix:contents>
								        </uix:rowLayout>
--%>								        
								        <uix:rowLayout>
								            <uix:contents>
								                <uix:cellFormat hAlign="right">
								                    <uix:contents>
								                        <uix:spacer height="10" width="10" />
								                    </uix:contents>
								                </uix:cellFormat>
								                <uix:cellFormat>
								                    <uix:contents>
								                        <uix:messageCheckBox name="frozen" checkedBinding="frozen@objectBean@servletRequest" onClick="submitForm('editWorkspaceForm', true, {event:'freezeSelection'})" textBinding="FREEZE_WORKSPACE_FIELD_HEADER@uixWorkspaceObjectBundle" />
								                    </uix:contents>
								                </uix:cellFormat>
								            </uix:contents>
								        </uix:rowLayout>
								        <uix:rowLayout>
								            <uix:contents>
								                <uix:cellFormat hAlign="right" vAlign="top">
								                    <uix:contents>
								                        <uix:styledText styleClass="OraInstructionText" textBinding="FREEZE_OPTIONS_FIELD_HEADER@uixWorkspaceObjectBundle" />
								                        <uix:spacer height="10" width="10" />
								                    </uix:contents>
								                </uix:cellFormat>
								                <uix:cellFormat>
								                    <uix:contents>
								                        <uix:stackLayout>
								                            <uix:contents>
 									                            <uix:tableLayout>
										                            <uix:contents>
							                                            <uix:rowLayout>
							                                              <uix:contents>
									  				                        <uix:messageRadioButton textBinding="FREEZE_READ_ONLY@uixWorkspaceObjectBundle" tipBinding="FREEZE_READ_ONLY_INFO@uixWorkspaceObjectBundle" name="freezeMode" value="READ_ONLY" selectedValueBinding="freezeMode@objectBean@servletRequest" disabledBinding="disableFreezeOptions@objectBean@servletRequest" />
							                                              </uix:contents>
							                                            </uix:rowLayout>
							                                            <uix:rowLayout>
							                                              <uix:contents>
				  				  				                        <uix:messageRadioButton textBinding="FREEZE_WM_ONLY@uixWorkspaceObjectBundle" tipBinding="FREEZE_WM_ONLY_INFO@uixWorkspaceObjectBundle" name="freezeMode"  value="WM_ONLY"  selectedValueBinding="freezeMode@objectBean@servletRequest" disabledBinding="disableFreezeOptions@objectBean@servletRequest"  />
							                                              </uix:contents>
							                                            </uix:rowLayout>
							                                            <uix:rowLayout>
							                                              <uix:contents>
									  				                        <uix:messageRadioButton textBinding="FREEZE_NO_ACCESS@uixWorkspaceObjectBundle" tipBinding="FREEZE_NO_ACCESS_INFO@uixWorkspaceObjectBundle"  name="freezeMode" value="NO_ACCESS"  selectedValueBinding="freezeMode@objectBean@servletRequest" disabledBinding="disableFreezeOptions@objectBean@servletRequest"  />
							                                              </uix:contents>
							                                            </uix:rowLayout>
							                                            <uix:rowLayout>
							                                              <uix:contents>
					  				  				                        <uix:messageRadioButton textBinding="FREEZE_SINGLE_WRITER@uixWorkspaceObjectBundle" tipBinding="FREEZE_SINGLE_WRITER_INFO@uixWorkspaceObjectBundle" name="freezeMode" value="1WRITER"  selectedValueBinding="freezeMode@objectBean@servletRequest" disabledBinding="disableFreezeOptions@objectBean@servletRequest" />
											                                <uix:messageLovField promptBinding="USER@uixWorkspaceObjectBundle"
																			searchDescBinding="FREEZE_SINGLE_WRITER@uixWorkspaceObjectBundle"
																			name="freezeWriter" 	shortDescBinding="SCHEMA_NAME_COLON@uixDBObjectBundle@servletRequest" onClick = "startLov('freezeWriter', 'ListSchema')" textBinding="freezeWriter@objectBean@servletRequest"/> 
							                                              </uix:contents>
							                                            </uix:rowLayout>
					                                              </uix:contents>
				                                            </uix:tableLayout>
								                            </uix:contents>
								                        </uix:stackLayout>
								                    </uix:contents>
								                </uix:cellFormat>
								            </uix:contents>
								        </uix:rowLayout>
								    </uix:contents>
								</uix:tableLayout>
					</uix:subTabLayout>
    	            <uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                   			 <jsp:include page="/database/schema/pageButtonInclude.jsp" />
	                    		<uix:ref refID="pageButtonInclude" />
	                  	</uix:pageButtonBar>
                	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
