<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%-- Page:        general.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description: general attributtes of workspace.
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixSDKUIMsgBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>    
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
		<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="editWorkspaceForm" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/generalPage" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
				<uix:subTabLayout>
						<uix:subTabs>
					        <uix:subTabBar selectedIndex="0">
							<!--Tab Code Start-->
					        <uix:contents>
					        	<uix:link textBinding="GENERAL_TAB@uixWorkspaceObjectBundle"/>

					        	<uix:link textBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'privilegeTab'})"/>

					        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
                                  	<uix:case name="true">    	
										<uix:link textBinding="FREEZE_TAB@uixWorkspaceObjectBundle"  
							        		onClick="submitForm('editWorkspaceForm', true, {event:'freezeTab'})"/>
					        		</uix:case>
                                </uix:switcher>   
					        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
                                  	<uix:case name="true">    	
							        	<uix:link textBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"  
							        		onClick="submitForm('editWorkspaceForm', true, {event:'savepointTab'})"/>
					        		</uix:case>
                                </uix:switcher>   
					        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
                                  	<uix:case name="true">    	
							        	<uix:link textBinding="SESSION_TAB@uixWorkspaceObjectBundle"  
							        		onClick="submitForm('editWorkspaceForm', true, {event:'sessionTab'})"/>
					        		</uix:case>
                                </uix:switcher>   
					        </uix:contents>
					       <!--Tab Code END-->
					       </uix:subTabBar>
				          </uix:subTabs>					       
								<uix:tableLayout cellSpacing="5" hAlign="center" width="75%">
						            <uix:contents>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right">
						                            <uix:contents>
											        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
						                                  	<uix:case name="true">    	
								                                <uix:messagePrompt promptBinding="NAME_HEADER@uixWorkspaceObjectBundle" />									                                
											        		</uix:case>
						                                  	<uix:case name="false">    	
								                                <uix:messagePrompt promptBinding="NAME_HEADER@uixWorkspaceObjectBundle" required="yes"/>
											        		</uix:case>
						                                </uix:switcher>   
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
											        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
						                                  	<uix:case name="true">    	
									                                <uix:styledText styleClass="OraDataText"  textBinding="workspaceName@objectBean@servletRequest"/>						                                  	
											        		</uix:case>
						                                  	<uix:case name="false">    	
									                                <uix:messageTextInput name="workspaceName"
																	shortDescBinding="NAME_HEADER@uixWorkspaceObjectBundle"
																
id="workspaceName" labeledNodeId="workspaceName" styleClass="OraInstructionText" textBinding="workspaceName@objectBean@servletRequest"/>						                                  	
											        		</uix:case>
						                                </uix:switcher>   
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right">
						                            <uix:contents>
						                                <uix:styledText styleClass="OraInstructionText" shortDescBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" textBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" />
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>

						                        <uix:cellFormat>
						                            <uix:contents>
	                          							<uix:textInput id="description" name="description" shortDescBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle"
														 rows="2" columns="45" textBinding="description@objectBean@servletRequest" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right" vAlign="top">
						                            <uix:contents>
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:messageCheckBox name="continuallyRefreshed" checkedBinding="continuallyRefreshed@objectBean@servletRequest" disabledBinding="disableContinuallyRefreshed@objectBean@servletRequest" textBinding="CONTINUALLY_REFRESHED_TIP@uixWorkspaceObjectBundle"/>
						                    </uix:contents>
						                </uix:rowLayout>
<%--- Create switcher START--%>			
				                <uix:switcher childNameBinding="editing@objectBean@servletRequest">
	                               	<uix:case name="true"> 
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right">
						                            <uix:contents>
						                                <uix:styledText styleClass="OraInstructionText" textBinding="OWNER_HEADER@uixWorkspaceObjectBundle" />
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
						                                <uix:styledText styleClass="OraDataText" textBinding="owner@objectBean@servletRequest"  />
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
									</uix:case>
                                </uix:switcher>  		
<%--- Create switcher END--%>						                                                                                				                
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right">
						                            <uix:contents>
						                               	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
						                                  	<uix:case name="true">    	
								                                <uix:messagePrompt promptBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />									                                
											        		</uix:case>
						                                  	<uix:case name="false">    	
								                                <uix:messagePrompt promptBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle" required="yes"/>
											        		</uix:case>
						                                </uix:switcher>   
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
											        	<uix:switcher childNameBinding="creating@objectBean@servletRequest">
						                                  	<uix:case name="true">    	
 								                                <uix:messageLovField 
																searchDescBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle"
																name="parentWorkspace" onClick = "preserveCase();startLov('parentWorkspace', 'ListWorkspaces')" textBinding="parentWorkspace@objectBean@servletRequest" shortDescBinding="WORKSPACES_HEADER@uixWorkspaceObjectBundle"/>
											        		</uix:case>
						                                  	<uix:case name="false">    	
									                                <uix:styledText styleClass="OraDataText"  textBinding="parentWorkspace@objectBean@servletRequest"/>						                                  	
											        		</uix:case>
						                                </uix:switcher>   
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:switcher childNameBinding="creating@objectBean@servletRequest">
					                    	<uix:case name="false">    	
								                <uix:rowLayout>
								                    <uix:contents>
								                        <uix:cellFormat hAlign="right">
								                            <uix:contents>
								                                <uix:styledText styleClass="OraInstructionText" textBinding="PARENT_SP_HEADER@uixWorkspaceObjectBundle" />
								                                <uix:spacer height="10" width="10" />
								                            </uix:contents>
								                        </uix:cellFormat>
								                        <uix:cellFormat>
								                            <uix:contents>
								                                <uix:styledText styleClass="OraDataText"  textBinding="parentSavepoint@objectBean@servletRequest"/>						                                  	
								                                <uix:spacer height="10" width="10" />
								                            </uix:contents>
								                        </uix:cellFormat>
								                    </uix:contents>
								                </uix:rowLayout>
							        		</uix:case>
					                    	<uix:case name="true">    	
								                <uix:rowLayout vAlign="top">
								                    <uix:contents>
								                        <uix:cellFormat hAlign="right">
								                            <uix:contents>
								                                <uix:styledText styleClass="OraInstructionText" textBinding="USE_DATA@uixWorkspaceObjectBundle" />
								                                <uix:spacer height="10" width="10" />
								                            </uix:contents>
								                        </uix:cellFormat>
								                        <uix:cellFormat>
								                            <uix:contents>
									                             <uix:stackLayout>
										                          <uix:contents>
											                        <uix:tableLayout>
												                      <uix:contents>
								                                          <uix:rowLayout>
								                                              <uix:contents>
												                            	<uix:radioButton textBinding="CURRENT_DATA@uixWorkspaceObjectBundle" name="parentSavePointSelOption" value="LATEST" selectedValueBinding="parentSavePointSelOption@objectBean@servletRequest" />
						            		                                  </uix:contents>
						                    		                        </uix:rowLayout>
						                            		                <uix:rowLayout>
						                                    		          <uix:contents>
			  				  				                        			<uix:radioButton textBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" name="parentSavePointSelOption"  value="SAVEPOINT_OTHER"  selectedValueBinding="parentSavePointSelOption@objectBean@servletRequest" />
						  				  				                        <uix:spacer width="10" height="10"/>
																                <uix:switcher childNameBinding="disableParentSavePoint@objectBean@servletRequest">
															                    	<uix:case name="true">    	
			 											                                <uix:messageLovField 
																						searchDescBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle"
																						name="parentSavepoint" onClick = "preserveCase();setBindSqlParm('parentWorkspace');startLov('parentSavepoint', 'ListWorkspaceSavepoint')" shortDescBinding="SAVEPOINTS_HEADER@uixWorkspaceObjectBundle" />  
																	        		</uix:case>					
													        		            	<uix:case name="false">    	
			 								                    			            <uix:messageLovField 
																						searchDescBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle"
																						name="parentSavepoint" onClick = "preserveCase();setBindSqlParm('parentWorkspace');startLov('parentSavepoint', 'ListWorkspaceSavepoint')" textBinding="parentSavepoint@objectBean@servletRequest" shortDescBinding="SAVEPOINTS_HEADER@uixWorkspaceObjectBundle"/>  
																	        		</uix:case>																				        		                    								        		
												                                </uix:switcher>   
								                                              </uix:contents>
								                                            </uix:rowLayout>
							                                            </uix:contents>
  						                                              </uix:tableLayout>
										                            </uix:contents>
										                        </uix:stackLayout>
								                            </uix:contents>
								                        </uix:cellFormat>
								                    </uix:contents>
								                </uix:rowLayout>
							        		</uix:case>					                    								        		
	                                </uix:switcher>   
								                
<%--- edit switcher START--%>						                
				                <uix:switcher childNameBinding="editing@objectBean@servletRequest">
	                               	<uix:case name="true"> 
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:cellFormat hAlign="right">
						                            <uix:contents>
						                                <uix:styledText styleClass="OraInstructionText" textBinding="TIME_CREATED_HEADER@uixWorkspaceObjectBundle" />
						                                <uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                        <uix:cellFormat>
						                            <uix:contents>
						                                <uix:styledText styleClass="OraDataText" textBinding="createTime@objectBean@servletRequest"  />
														<uix:spacer height="10" width="10" />
						                            </uix:contents>
						                        </uix:cellFormat>
						                    </uix:contents>
						                </uix:rowLayout>
									</uix:case>
                                </uix:switcher>  		
<%--- edit switcher END--%>						                                                
                                				                
						            </uix:contents>
						        </uix:tableLayout>
				</uix:subTabLayout>

                <uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                   			 <jsp:include page="pageButtonInclude.jsp" />
	                    		<uix:ref refID="pageButtonInclude" />
	                  	</uix:pageButtonBar>
              	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
