<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>


<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        privilegePage.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description: 
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
		<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="editWorkspaceForm" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/privilegePage" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
				<uix:subTabLayout>
						<uix:subTabs>
					        <uix:subTabBar selectedIndex="1">
							<!--Tab Code Start-->
					        <uix:contents>
					        	<uix:link textBinding="GENERAL_TAB@uixWorkspaceObjectBundle" 
										onClick="submitForm('editWorkspaceForm', true, {event:'generalTab'})"/>
					        	<uix:link textBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"/>
					        	
								<uix:switcher childNameBinding="editing@objectBean@servletRequest">
                                  	<uix:case name="true">    	
										<uix:link textBinding="FREEZE_TAB@uixWorkspaceObjectBundle"  
							        		onClick="submitForm('editWorkspaceForm', true, {event:'freezeTab'})"/>
					        		</uix:case>
                                </uix:switcher>   
					        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
                                  	<uix:case name="true">    	
							        	<uix:link textBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"  
							        		onClick="submitForm('editWorkspaceForm', true, {event:'savepointTab'})"/>
					        		</uix:case>
                                </uix:switcher>   
					        	<uix:switcher childNameBinding="editing@objectBean@servletRequest">
                                  	<uix:case name="true">    	
							        	<uix:link textBinding="SESSION_TAB@uixWorkspaceObjectBundle"  
							        		onClick="submitForm('editWorkspaceForm', true, {event:'sessionTab'})"/>
					        		</uix:case>
                                </uix:switcher>   
					        </uix:contents>
					       <!--Tab Code END-->
					       </uix:subTabBar>
						</uix:subTabs>					       
					       <uix:spacer height="10" width="10" />
						   <uix:table name="privilegesListTable"
								alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
								summaryBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"
								formSubmitted="true" 
								width="100%" 
								tableDataBinding="rowData@privilegebean@servletRequest"
								blockSizeBinding="blockSize@privilegebean@servletRequest" 
					            maxValueBinding="numRows@privilegebean@servletRequest"
		            			valueBinding="startIndex@privilegebean@servletRequest" >
								    <uix:tableFormat tableBanding="rowBanding" />
										<uix:tableSelection>
					                       <uix:multipleSelection  selectedBinding = "uiIsSelected"
										   shortDescBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle">

						                         <uix:contents>
		                                           <uix:submitButton textBinding="REMOVE@uixDBObjectBundle" name="event" value="DELETE_PRIVILEGE" shortDescBinding="DELETE@uixDBObjectBundle"/>	                                           
						                         </uix:contents>
						                       </uix:multipleSelection>
							            </uix:tableSelection>								    
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="USER_NAME_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiUserSort@savepointbean@servletRequest" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="16%" />
								        	<uix:messageLovField name="USER_NAME_HEADER" 
											searchDescBinding="USER_NAME_HEADER@uixWorkspaceObjectBundle"
                                            id="USER_NAME_HEADER"   textBinding="USER_NAME_HEADER"
											shortDescBinding="SCHEMA_NAME_COLON@uixDBObjectBundle"
		                                     onClickBinding="<%=WorkspaceConstants.USER_LOV_URL%>"/>
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="ACCESS_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:checkBox name="ACCESS_WORKSPACE_HEADER" checkedBinding="ACCESS_WORKSPACE_HEADER"/>
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="CREATE_WORKSPACE_HEADER@uixWorkspaceObjectBundle"  />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:checkBox name="CREATE_WORKSPACE_HEADER" checkedBinding="CREATE_WORKSPACE_HEADER"/>
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="FREEZE_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:checkBox name="FREEZE_WORKSPACE_HEADER" checkedBinding="FREEZE_WORKSPACE_HEADER"/>
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="MERGE_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:checkBox name="MERGE_WORKSPACE_HEADER" 
									
 checkedBinding="MERGE_WORKSPACE_HEADER"/>
								    </uix:column>
								    
								    <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="REMOVE_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="13%" />
	  								        <uix:checkBox name="REMOVE_WORKSPACE_HEADER" checkedBinding="REMOVE_WORKSPACE_HEADER"/>
								    </uix:column>
								    
							        <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="ROLLBACK_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="13%" />
	  								        <uix:checkBox name="ROLLBACK_WORKSPACE_HEADER" checkedBinding="ROLLBACK_WORKSPACE_HEADER"/>								            
								    </uix:column>

								    <uix:columnFooter>
						              <uix:submitButton textBinding="ADD_PRIVILEGES@uixWorkspaceObjectBundle" 
						                                shortDescBinding="ADD_PRIVILEGES@uixWorkspaceObjectBundle" 
						                                name="event" 
						                                value="<%=WorkspaceConstants.EVENT_ADD_PRIVILEGES%>"/>
						            </uix:columnFooter>
								</uix:table>
					</uix:subTabLayout>
                    <uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                   			 <jsp:include page="/database/schema/pageButtonInclude.jsp" />
	                    		<uix:ref refID="pageButtonInclude" />
	                  	</uix:pageButtonBar>
                	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
