<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%-- Page:        refreshWorkspace.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description: The screen gives overview of selected workspace.
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
		<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="refreshWorkspaceForm" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/refreshWorkspace" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />

                    <uix:styledText styleClass="OraInstructionText" textBinding="REFRESH_INFO@uixWorkspaceObjectBundle"  />
                  	<uix:spacer width="10" height="10"/>
                    
					<uix:tableLayout cellSpacing="5" hAlign="center">
					    <uix:contents>
					        <uix:rowLayout>
					            <uix:contents>
					                <uix:cellFormat hAlign="right">
					                    <uix:contents>
					                        <uix:styledText styleClass="OraInstructionText" textBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
					                        <uix:spacer height="10" width="20" />
					                    </uix:contents>
					                </uix:cellFormat>
					                <uix:cellFormat>
					                    <uix:contents>
					                        <uix:styledText styleClass="OraDataText"  textBinding="workspaceName@objectBean@servletRequest"/>
					                    </uix:contents>
					                </uix:cellFormat>
					            </uix:contents>
					        </uix:rowLayout>

        			        <uix:rowLayout>
					            <uix:contents>
					                <uix:cellFormat hAlign="right" >
					                    <uix:contents>
					                        <uix:styledText styleClass="OraInstructionText" textBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle"/>
					                        <uix:spacer height="10" width="20" />
					                    </uix:contents>
					                </uix:cellFormat>
					                <uix:cellFormat >
					                    <uix:contents>
					                        <uix:styledText styleClass="OraDataText"  textBinding="parentWorkspace@objectBean@servletRequest"/>
					                    </uix:contents>
					                </uix:cellFormat>
					            </uix:contents>
					        </uix:rowLayout>

					        <uix:rowLayout vAlign="top">
					            <uix:contents>
					                <uix:cellFormat hAlign="right">
					                    <uix:contents>
					                        <uix:styledText styleClass="OraInstructionText" textBinding="REFRESH_SELECT_OPTION@uixWorkspaceObjectBundle" />
					                        <uix:spacer height="10" width="20" />
					                    </uix:contents>
					                </uix:cellFormat>
					                <uix:cellFormat>
					                    <uix:contents>
					                        <uix:stackLayout>
					                            <uix:contents>
					                                <uix:tableLayout>
					                                    <uix:contents>
					                                        <uix:rowLayout>
					                                            <uix:contents>
					                                                <uix:messageRadioButton name="operationSelOption" value="REFRESH_COMPLETE_WORKSPACE" textBinding="REFRESH_COMPLETE_WORKSPACE@uixWorkspaceObjectBundle" selectedValueBinding="operationSelOption@operationsOptions@objectBean@servletRequest"  />
					                                            </uix:contents>
					                                        </uix:rowLayout>
					                                        <uix:rowLayout>
					                                            <uix:contents>
					                                                <uix:messageRadioButton name="operationSelOption" value="REFRESH_SELECTED_TABLE" textBinding="REFRESH_SELECTED_TABLE@uixWorkspaceObjectBundle" selectedValueBinding="operationSelOption@operationsOptions@objectBean@servletRequest" />
					                                                <uix:spacer width="10" height="10" />
   						                    			            <uix:messageLovField 
																	searchDescBinding="REFRESH_SELECTED_TABLE@uixWorkspaceObjectBundle"
																	name="selectedTable" rows="5" columns="45" onClick = "selectMultiple();appendData();startLov('selectedTable', 'ListWorkspaceTables')" textBinding="selectedTable@operationsOptions@objectBean@servletRequest" shortDescBinding="VERSION_ENABLED_TABLES@uixWorkspaceObjectBundle"/>    
					                                            </uix:contents>
					                                        </uix:rowLayout>
					                                    </uix:contents>
					                                </uix:tableLayout>
					                            </uix:contents>
					                        </uix:stackLayout>
					                    </uix:contents>
					                </uix:cellFormat>
					            </uix:contents>
					        </uix:rowLayout>
					    </uix:contents>
					</uix:tableLayout>

                <uix:pageButtons>
	          	  		<uix:pageButtonBar>
                    			 <jsp:include page="workspaceButtonInclude.jsp" />
	                     		 <uix:ref refID="operationButtonInclude" />
	                  	</uix:pageButtonBar>
              	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
