<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        savepointPage.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description:  
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="editWorkspaceForm" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/savepointPage" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
				<uix:subTabLayout>
						<uix:subTabs>				
					        <uix:subTabBar selectedIndex="3">
							<!--Tab Code Start-->
					        <uix:contents>
					        	<uix:link textBinding="GENERAL_TAB@uixWorkspaceObjectBundle" 
										onClick="submitForm('editWorkspaceForm', true, {event:'generalTab'})"/>
					        	<uix:link textBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'privilegeTab'})"/>
								<uix:link textBinding="FREEZE_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'freezeTab'})"/>
					        	<uix:link textBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"/>
					        	<uix:link textBinding="SESSION_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'sessionTab'})"/>
					        </uix:contents>
					       <!--Tab Code END-->
					       </uix:subTabBar>
						</uix:subTabs>							
		                   <uix:styledText styleClass="OraInstructionText" textBinding="SAVEPOINT_INFO@uixWorkspaceObjectBundle"  />		       
					       <uix:spacer height="10" width="10" />
								<uix:table name="savepointsListTable"
								summaryBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"
								alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
								formSubmitted="true" 
								width="100%" 
								tableDataBinding="rowData@savepointbean@servletRequest"
								blockSizeBinding="blockSize@savepointbean@servletRequest" 
					            maxValueBinding="numRows@savepointbean@servletRequest"
		            			valueBinding="startIndex@savepointbean@servletRequest" >
								    <uix:tableFormat tableBanding="rowBanding" />
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="NAME_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiNameSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								        <uix:text textBinding="NAME_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiDescriptionSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								        <uix:text textBinding="DESCRIPTION_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="TYPE_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTypeSort@savepointbean@servletRequest" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" />
								        <uix:text textBinding="TYPE_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="OWNER_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiOwnerSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="10%" />
								        <uix:text textBinding="OWNER_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="POSITION_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiPositionSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="10%" />
								        <uix:text textBinding="POSITION_HEADER" />
								    </uix:column>
								    <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="TIME_CREATED_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTimeCreatedSort@savepointbean@servletRequest"/>
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								            <uix:text textBinding="TIME_CREATED_HEADER" />
								    </uix:column>
								</uix:table>
				</uix:subTabLayout>								
                <uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                   			 <jsp:include page="/database/schema/pageButtonInclude.jsp" />
	                    		<uix:ref refID="pageButtonInclude" />
	                  	</uix:pageButtonBar>
              	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
