
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%-- Page:        searchVesrionEnabledObjects.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/VersionedObjectController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.version.VersionEnabledObject
  -- Description: This is the central screen to manage Versioning functionality.
  --%>
  
<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg" />
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
		<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="veObjects" method="post" destination="/console/database/workspacemgr/versionedObject" copyParams="target,type,otype,oname,objectType">
                <uix:formValue name="pageName" value="/database/workspace/searchVersionEnabledObjects" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                        <uix:tableLayout width="100%" renderedBinding="spatial@objectBean@servletRequest">
                            <uix:contents>
                                <uix:rowLayout hAlign="left">
                                    <uix:contents>
                                        <uix:messageRadioSet name="selectedObjectTypeOption" promptBinding="TYPE_HEADER@uixWorkspaceObjectBundle" selectedValueBinding="topologiesSelectedTxt@objectBean@servletRequest">
                                            <uix:contents>
                                                <uix:option textBinding="TABLE_HEADER@uixWorkspaceObjectBundle" value="TABLE_HEADER"/>
                                                <uix:option textBinding="TOPOLOGY_HDR@uixWorkspaceObjectBundle"  value="TOPOLOGY_HDR" />
                                            </uix:contents>
                                        </uix:messageRadioSet>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                        <uix:header textBinding="SEARCH@uixDBObjectBundle">
                            <uix:contents>
  				                <uix:styledText  styleClass="OraInstructionText"  textBinding="SEARCH_SCHEMA_OBJECT_INTS@uixDBObjectBundle" />
                                <uix:tableLayout cellSpacing="5">
                                    <uix:contents>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat width="20%" hAlign="right">
                                                    <uix:contents>
                                                        <uix:styledText labeledNodeId="schemaName"
		                                                  styleClass="OraPromptText"  textBinding="SCHEMA_NAME_COLON@uixDBObjectBundle" />
                                                     </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
					                                <uix:messageLovField name="schemaName"
					                                             id="schemaName"
																 searchDescBinding="SCHEMA_NAME_COLON@uixDBObjectBundle"
					                                             textBinding="selSchema@objectBean@servletRequest"
					                                             shortDescBinding="SCHEMA_NAME_COLON@uixDBObjectBundle@servletRequest"
					                                             onClick = "startLov('schemaName', 'ListSchema')"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:contents>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat width="20%" hAlign="right">
                                                    <uix:contents>
                                                        <uix:styledText styleClass="OraPromptText" 
														labeledNodeId="objectName"
														textBinding="OBJECT_NAME_COLON@uixDBObjectBundle"  />
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:messageTextInput name="objectName"
											
shortDescBinding="OBJECT_NAME_COLON@uixDBObjectBundle" styleClass="OraInstructionText"  
                                                	id="objectName" textBinding="selObjectName@objectBean@servletRequest"/>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat width="20%" hAlign="right">
                                                    <uix:contents>
                                                        <uix:spacer height="10" width="10" />
                                                    </uix:contents>
                                                </uix:cellFormat>
						                        <uix:messageCheckBox name="versionOnlyOption" 
						                        checkedBinding="searchVersionOption@objectBean@servletRequest" 
												textBinding="VERSIONED_ONLY@uixWorkspaceObjectBundle" />
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat width="20%" hAlign="right">
                                                    <uix:contents>
                                                    </uix:contents>
                                                </uix:cellFormat>
						                   <uix:submitButton textBinding="GO@uixDBObjectBundle" 
                        		             onFocus="true" selected="true" name="event" value="search"/>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                                <uix:spacer height="20" width="10" />
  				                <uix:styledText styleClass="OraInlineInfoText" textBinding="SEARCH_HINT@uixDBObjectBundle" />

					            <uix:separator />

                                <uix:tableLayout width="100%">
                                    <uix:contents>
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:spacer height="10" width="10" />
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:table name="searchVersionObjectTable" 
												summaryBinding="VERSION_ENABLED_TABLES@uixWorkspaceObjectBundle"
												alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" formSubmitted="true" width="100%" tableDataBinding="rowData@searchVersionObjectbean@servletRequest" blockSizeBinding="blockSize@searchVersionObjectbean@servletRequest" maxValueBinding="numRows@searchVersionObjectbean@servletRequest" valueBinding="startIndex@searchVersionObjectbean@servletRequest">
                                                    <uix:tableFormat tableBanding="rowBanding" />
                                                    <uix:tableSelection>
                                                        <uix:multipleSelection selectedBinding = "uiIsSelected"
														shortDescBinding="VERSION_ENABLED_TABLES@uixWorkspaceObjectBundle">
                                                            <uix:contents>
									                           <uix:messageChoice name="selectedOperationChoice" promptBinding="ACTIONS@uixDBObjectBundle">
																    <uix:contents childDataBinding="versioningDropDownOptions@searchVersionObjectbean@servletRequest">
        	                    										<uix:option textBinding="textKey" valueBinding="valueKey"/>
										       		                </uix:contents>
									       					   </uix:messageChoice>
									                           <uix:spacer width="10" height="10"/>
									                           <uix:submitButton name="event" value="operationsGo" textBinding="GO@uixDBObjectBundle" shortDescBinding="GO@uixDBObjectBundle" />
                                                            </uix:contents>
                                                        </uix:multipleSelection>
                                                    </uix:tableSelection>
                                                    <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="SCHEMA_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiSchemaSort@searchVersionObjectbean@servletRequest" />
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="objectNameFormat" width="15%" />
                                                        <uix:text textBinding="SCHEMA_HEADER" />
                                                    </uix:column>
                                                    <uix:column>
                                                        <uix:columnHeader>
                                                           	<uix:switcher childNameBinding="topologiesSelected@objectBean@servletRequest">
							                                  	<uix:case name="false">    	
		                                                            <uix:sortableHeader textBinding="TABLE_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTableNameSort@searchVersionObjectbean@servletRequest" />					    							    		
	                                                            </uix:case>
	                                                            <uix:case name="true">    	
		                                                            <uix:sortableHeader textBinding="TOPOLOGY_HDR@uixWorkspaceObjectBundle" sortableBinding="uiTableNameSort@searchVersionObjectbean@servletRequest" />					    							    		
	                                                            </uix:case>
							                                </uix:switcher>   
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="textFormat" width="20%" />
                                                        <uix:text textBinding="TABLE_HEADER" />
                                                    </uix:column>
                                                    <uix:column>
                                                        <uix:columnHeader>
                                                            <uix:sortableHeader textBinding="IS_VERSIONED_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiVersionedSort@searchVersionObjectbean@servletRequest" />
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="textFormat" width="10%" />
                                                        <uix:image sourceBinding="IS_VERSIONED_HEADER"/>
                                                    </uix:column>
                                                </uix:table>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>
                            </uix:contents>
                        </uix:header>
                    </uix:contents>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
