<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        sessionPage.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description: 
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="editWorkspaceForm" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/sessionPage" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
				<uix:subTabLayout>
						<uix:subTabs>				
					        <uix:subTabBar selectedIndex="4">
							<!--Tab Code Start-->
					        <uix:contents>
					        	<uix:link textBinding="GENERAL_TAB@uixWorkspaceObjectBundle" 
										onClick="submitForm('editWorkspaceForm', true, {event:'generalTab'})"/>
					        	<uix:link textBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'privilegeTab'})"/>
								<uix:link textBinding="FREEZE_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'freezeTab'})"/>
					        	<uix:link textBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"  
					        		onClick="submitForm('editWorkspaceForm', true, {event:'savepointTab'})"/>
					        	<uix:link textBinding="SESSION_TAB@uixWorkspaceObjectBundle" />
					        </uix:contents>
					       <!--Tab Code END-->
					       </uix:subTabBar>
						</uix:subTabs>									       
		               <uix:styledText styleClass="OraInstructionText" textBinding="SESSION_INFO@uixWorkspaceObjectBundle"  />		       
				       <uix:spacer height="10" width="10" />
								<uix:table name="sessionsListTable" 
									id="sessionsListUI" 
									summaryBinding="SESSION_TAB@uixWorkspaceObjectBundle"
									alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
									formSubmitted="true" 
									width="100%" 
									tableDataBinding="rowData@sessionbean@servletRequest"
									blockSizeBinding="blockSize@sessionbean@servletRequest" 
									maxValueBinding="numRows@sessionbean@servletRequest"
									valueBinding="startIndex@sessionbean@servletRequest" >
						        
						            <uix:tableFormat tableBanding="rowBanding" />
						            <uix:column>
						                <uix:columnHeader>
						                    <uix:sortableHeader textBinding="SESSIONID_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiSessionIdSort@sessionbean@servletRequest" />
						                </uix:columnHeader>
						                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                <uix:text textBinding="SESSIONID_HEADER" />
						            </uix:column>
						            <uix:column>
						                <uix:columnHeader>
						                    <uix:sortableHeader textBinding="USER_NAME_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiUserSort@sessionbean@servletRequest" />
						                </uix:columnHeader>
						                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                <uix:text textBinding="USER_NAME_HEADER" />
						            </uix:column>
						            <uix:column>
						                <uix:columnHeader>
						                    <uix:sortableHeader textBinding="STATUS_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiStatusSort@sessionbean@servletRequest" />
						                </uix:columnHeader>
						                <uix:columnFormat columnDataFormat="textFormat" width="40%" />
						                <uix:text textBinding="STATUS_HEADER" />
						            </uix:column>
						            </uix:table>
				</uix:subTabLayout>
                <uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                   			 <jsp:include page="/database/schema/pageButtonInclude.jsp" />
	                    		<uix:ref refID="pageButtonInclude" />
	                  	</uix:pageButtonBar>
              	</uix:pageButtons>				
              </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
