<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>

<%-- Page:        showConflictsSelTable.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: 
  --%>

	<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixSDKUIMsgBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="workspaceConflicts" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/showConflictsSelTable" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                        <uix:labeledFieldLayout >
						    <uix:messagePrompt promptBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />
						    <uix:messagePrompt promptBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="parentWorkspace@objectBean@servletRequest" />
						</uix:labeledFieldLayout>
                        <uix:header textBinding="SELECT_VERSIONED_TABLE_HEADER@uixWorkspaceObjectBundle"  renderedBinding="dataExists@objectBean@servletRequest">
						    <uix:contents>
						        <uix:tableLayout width="100%">
						            <uix:contents>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:styledText styleClass="OraInstructionText" textBinding="CONFLICT_SELECT_TABLE_MSG@uixWorkspaceObjectBundle" />
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:spacer height="10" width="10" />
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout width="100%">
						                    <uix:contents>
						                        <uix:table name="<%=WorkspaceConstants.CONFLICTINGTABLES_UI_TABLE%>" 
						                        alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
												summaryBinding="CONFLICT_SELECT_TABLE_MSG@uixWorkspaceObjectBundle"
						                        formSubmitted="true" width="100%" 
						                        tableDataBinding="rowData@conflictingTablesbean@servletRequest" 
						                        blockSizeBinding="blockSize@conflictingTablesbean@servletRequest" 
						                        maxValueBinding="numRows@conflictingTablesbean@servletRequest" 
						                        valueBinding="startIndex@conflictingTablesbean@servletRequest"
               			            	      renderedBinding="dataExists@objectBean@servletRequest"						                      
						                         >
						                            <uix:tableFormat tableBanding="rowBanding" />
													 <uix:tableSelection>
								                       <uix:singleSelection 
													   shortDescBinding="CONFLICT_SELECT_TABLE_MSG@uixWorkspaceObjectBundle"
													   selectedIndexBinding="selectedIndexUI@conflictingTablesbean@servletRequest" >
								                         <uix:contents>
															<uix:switcher childNameBinding="dataExists@objectBean@servletRequest">
										                  		<uix:case name="true">    	
																	    <uix:submitButton textBinding="CONFLICT_RESOLVE_INDIVIDUALLY@uixWorkspaceObjectBundle" 
														                      shortDescBinding="CONFLICT_RESOLVE_INDIVIDUALLY@uixWorkspaceObjectBundle"
														                      name="event" 
														                      value="SHOW_DETAILS_CONFLICTS"/>
											    	    		</uix:case>
										                    </uix:switcher>   						                      
								                         </uix:contents>
								                       </uix:singleSelection>
 								                    </uix:tableSelection>						                            
						                            <uix:column>
						                                <uix:columnHeader>
						                                    <uix:sortableHeader textBinding="SCHEMA_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiSchemaSort@conflictingTablesbean@servletRequest"/>
						                                </uix:columnHeader>
						                                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                                <uix:text textBinding="SCHEMA_HEADER" />
						                            </uix:column>
						                            <uix:column>
						                                <uix:columnHeader>
						                                    <uix:sortableHeader textBinding="TABLE_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTableNameSort@conflictingTablesbean@servletRequest"/>
						                                </uix:columnHeader>
						                                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                                <uix:text textBinding="TABLE_HEADER" />
						                            </uix:column>
   						                            <uix:column>
						                                <uix:columnHeader>
						                                    <uix:sortableHeader textBinding="CONFLICT_RESOLUTION_HDR@uixWorkspaceObjectBundle" />
						                                </uix:columnHeader>
						                                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
												        <uix:messageChoice name="CONFLICT_RESOLUTION_HDR"
						shortDescBinding="CONFLICT_RESOLUTION_HDR@uixWorkspaceObjectBundle"					
id="CONFLICT_RESOLUTION_HDR" selectedValueBinding="selResolveConflicts">
														    <uix:contents childDataBinding="dropParamOptions">
		                 										<uix:option textBinding="textKey" valueBinding="valueKey"/>
								       		                </uix:contents>
							       					   </uix:messageChoice>
						                            </uix:column>
						                        </uix:table>
						                    </uix:contents>
						                </uix:rowLayout>
						            </uix:contents>
						        </uix:tableLayout>
						    </uix:contents>
						</uix:header>
                    </uix:contents>
    
                     <uix:pageButtons>
	          	  		<uix:pageButtonBar>
							<uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
		    	              shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
		        	          name="event" 
		            	      value="showSql"
		            	      renderedBinding="dataExists@objectBean@servletRequest"
		            	       />
						    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
			                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
			                      name="event" 
			                      value="cancel"
       		            	      renderedBinding="dataExists@objectBean@servletRequest"
			                      />
						    <uix:submitButton textBinding="APPLY@uixSDKUIMsgBundle" 
			                      shortDescBinding="APPLY@uixSDKUIMsgBundle"
			                      name="event" 
			                      value="apply"
			            	      renderedBinding="dataExists@objectBean@servletRequest"						                      
			                      />
                          <uix:switcher childNameBinding="dataExists@objectBean@servletRequest">
						 	<uix:case name="false">    	
							    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
				                      shortDescBinding="OK@uixDBObjectBundle@servletRequest"
				                      name="event" 
				                      value="cancel"
				                      />
		    	    		</uix:case>
                          </uix:switcher>
                       	</uix:pageButtonBar>
	            	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
