<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>

<%-- Page:        showConflictsShowDetails.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: 
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixSDKUIMsgBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="conflictTableDetails" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/showConflictsShowDetails" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                        <uix:labeledFieldLayout >
						    <uix:messagePrompt promptBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />
						    <uix:messagePrompt promptBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="parentWorkspace@objectBean@servletRequest" />
						</uix:labeledFieldLayout>
                        <uix:header textBinding="fullyQualifiedName@selSearchedTable@objectBean@servletRequest">
						    <uix:contents>
						        <uix:tableLayout width="100%">
						            <uix:contents>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:styledText styleClass="OraInstructionText" textBinding="CONFLICT_TABLE_DETAILS_INFO@uixWorkspaceObjectBundle" />
						                    </uix:contents>
						                </uix:rowLayout>
   						                <uix:rowLayout>
						                    <uix:contents>
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:spacer height="10" width="10" />
						                    </uix:contents>
						                </uix:rowLayout>
<%--						                 <uix:rowLayout width="100%">
						                    <uix:contents>
						                    <uix:dataScope currentDataBinding="conflictingTableDetailsbean@servletRequest">
						                   		 <uix:include nodeBinding="conflictingTableDetailsbean@servletRequest"/>
						                    </uix:dataScope>
						                    </uix:contents>
						                </uix:rowLayout> --%>
										<uix:rowLayout width="100%">
						                    <uix:contents>
						                     <%
							                    boolean isDynaTableNotNull = false;
							                    Object  getIsDynaTableNotNull = request.getAttribute("isDynaTableNotNull");
							                    if (getIsDynaTableNotNull != null)
							                    	isDynaTableNotNull = ((Boolean)getIsDynaTableNotNull).booleanValue();					                    	
							            
												if ( isDynaTableNotNull )
												{
											%> 
												<oem:table name="tablesDetailsUITable" beanKey="dynaOEMTableDS"
					             						blockSize="10"  formSubmitted="true"
													
summaryBinding="CONFLICT_TABLE_DETAILS_INFO@uixWorkspaceObjectBundle"
		            			 					dataSourceProp="dynaTableUI" 
													alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
													width="100%" copyParams="target,type">
													 <uix:tableSelection>
									                       <uix:singleSelection 
														   shortDescBinding="CONFLICT_TABLE_DETAILS_INFO@uixWorkspaceObjectBundle"
														   selectedIndexBinding="selectedIndex@dynaOEMTableDS@servletRequest" >
									                         <uix:contents>
																<uix:switcher childNameBinding="dataExists@objectBean@servletRequest">
											                  		<uix:case name="true">    	
																		    <uix:submitButton textBinding="SHOW_DETAILS@uixWorkspaceObjectBundle" 
															                      shortDescBinding="SHOW_DETAILS@uixWorkspaceObjectBundle"
															                      name="event" 
															                      value="SHOW_DETAILS"/>
												    	    		</uix:case>
											                    </uix:switcher>   						                      
									                         </uix:contents>
									                       </uix:singleSelection>
	 								                    </uix:tableSelection>		
													</oem:table>		
													<%
													}
													%>				                    
											</uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:spacer height="10" width="10" />
						                    </uix:contents>
						                </uix:rowLayout>
						            </uix:contents>
						        </uix:tableLayout>
		                        <uix:header textBinding="SEL_ROW_DETAILS@uixWorkspaceObjectBundle" renderedBinding="isDynaTableNotNull@servletRequest">
								    <uix:contents>
								        <uix:tableLayout width="100%">
								            <uix:contents>
												<uix:rowLayout>
								                    <uix:contents>
														<uix:table name="rowDetailsUIXTableDS"
														alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
														summaryBinding="SEL_ROW_DETAILS@uixWorkspaceObjectBundle"
														formSubmitted="true" 
														width="80%" 
														tableDataBinding="rowData@rowDetailsUIXTableDS@servletRequest"
														blockSizeBinding="blockSize@rowDetailsUIXTableDS@servletRequest" 
											            maxValueBinding="numRows@rowDetailsUIXTableDS@servletRequest"
								            			valueBinding="startIndex@rowDetailsUIXTableDS@servletRequest" >
														    <uix:tableFormat tableBanding="rowBanding" />
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="COLUMN_NAME_HDR@uixWorkspaceObjectBundle"/>
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="COLUMN_NAME_HDR" />
														    </uix:column>
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="BASE_WORKSPACE_HDR@uixWorkspaceObjectBundle"/>
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="BASE_FIELD" />
														    </uix:column>
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="work1Name@rowDetailsUIXTableDS@servletRequest"  />
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="WORKSPACE1_FIELD" />
														    </uix:column>
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="work2Name@rowDetailsUIXTableDS@servletRequest" />
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="WORKSPACE2_FIELD" />
														    </uix:column>
														</uix:table>
													</uix:contents>
								                </uix:rowLayout>
										      <%-- tip --%>
										      <uix:rowLayout>
													<uix:contents>
												        <uix:tip textBinding="DETAILS_ACRONYM@uixWorkspaceObjectBundle"/>
													</uix:contents>
										      </uix:rowLayout>
								            </uix:contents>
								        </uix:tableLayout>
								    </uix:contents>
								</uix:header>
						    </uix:contents>
						</uix:header>
                    </uix:contents>
                     <uix:pageButtons>
	          	  		<uix:pageButtonBar>
<%-- 						
							<uix:styledText styleClass="OraPromptText" 
		                        textBinding="ACTIONS@uixDBObjectBundle@servletRequest"/>
          	  		        <uix:messageChoice name="resolutionDropDown" selectedValueBinding="resolveConflictOption@selSearchedTable@objectBean@servletRequest">
								    <uix:contents childDataBinding="resolutionDropDown@servletRequest">
 										<uix:option textBinding="textKey" valueBinding="valueKey"/>
		       		                </uix:contents> 
		       		        </uix:messageChoice>
          	  		        <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="operationsGo"/>
--%>
						    <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
		    	              shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"
		        	          name="event" 
		            	      value="showSql"
		            	      renderedBinding="dataExists@objectBean@servletRequest"
		            	       />
						    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
			                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
			                      name="event" 
			                      value="WORKSPACE_SHOW_CONFLICT_ACTION"
       		            	      renderedBinding="dataExists@objectBean@servletRequest"
			                      />
						    <uix:submitButton textBinding="APPLY@uixSDKUIMsgBundle" 
			                      shortDescBinding="APPLY@uixSDKUIMsgBundle"
			                      name="event" 
			                      value="apply"
			            	      renderedBinding="dataExists@objectBean@servletRequest"						                      
			                      />
                       	</uix:pageButtonBar>
	            	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
