<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>

<%-- Page:        showDiffsSelTable.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: 
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixSDKUIMsgBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="diffWorkspaces" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/showDiffsSelTable" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                        
                        <uix:labeledFieldLayout columns="2" >
						    <uix:messagePrompt promptBinding="DIFFS_SELECT_FIRST_WK_HDR@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />

						    <uix:messagePrompt promptBinding="DIFFS_SELECT_SECOND_WK_HDR@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceToCompare@operationsOptions@objectBean@servletRequest" />

						    <uix:messagePrompt promptBinding="SELECTED_SAVEPOINT@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="selectedSavepoint@operationsOptions@objectBean@servletRequest" />
						    
						    <uix:messagePrompt promptBinding="SELECTED_SAVEPOINT@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceToCompareSavepoint@operationsOptions@objectBean@servletRequest" />
						</uix:labeledFieldLayout>
                        <uix:header textBinding="SELECT_VERSIONED_TABLE_HEADER@uixWorkspaceObjectBundle">
						    <uix:contents>
						        <uix:tableLayout width="100%">
						            <uix:contents>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:styledText styleClass="OraInstructionText" textBinding="DIFFS_SELECT_TABLE_INFO@uixWorkspaceObjectBundle" />
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:spacer height="10" width="10" />
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout width="100%">
						                    <uix:contents>
						                        <uix:table name="<%=WorkspaceConstants.DIFFERINGTABLES_UI_TABLE%>" 
												summaryBinding="DIFFS_SELECT_TABLE_INFO@uixWorkspaceObjectBundle"
												alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" formSubmitted="true" width="100%" tableDataBinding="rowData@diffparentbean@servletRequest" blockSizeBinding="blockSize@diffparentbean@servletRequest" maxValueBinding="numRows@diffparentbean@servletRequest" valueBinding="startIndex@diffparentbean@servletRequest" >
						                            <uix:tableFormat tableBanding="rowBanding" />
													 <uix:tableSelection>
								                       <uix:singleSelection
shortDescBinding="DIFFS_SELECT_TABLE_INFO@uixWorkspaceObjectBundle"  selectedIndexBinding="selectedIndexUI@diffparentbean@servletRequest" />
 								                    </uix:tableSelection>						                            
						                            <uix:column>
						                                <uix:columnHeader>
						                                    <uix:sortableHeader textBinding="SCHEMA_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiSchemaSort@diffparentbean@servletRequest"/>
						                                </uix:columnHeader>
						                                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                                <uix:text textBinding="SCHEMA_HEADER" />
						                            </uix:column>
						                            <uix:column>
						                                <uix:columnHeader>
						                                    <uix:sortableHeader textBinding="TABLE_HEADER@uixWorkspaceObjectBundle"  sortableBinding="uiTableNameSort@diffparentbean@servletRequest"/>
						                                </uix:columnHeader>
						                                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                                <uix:text textBinding="TABLE_HEADER" />
						                            </uix:column>
						                        </uix:table>
						                    </uix:contents>
						                </uix:rowLayout>
						            </uix:contents>
						        </uix:tableLayout>
						    </uix:contents>
						</uix:header>
                    </uix:contents>
		                    <uix:location>
				                <uix:train selectedIndex="1">
				                    <uix:contents>
				                        <uix:link textBinding="DIFFS_TRAIN_SELECT_WKS@uixWorkspaceObjectBundle"/>
				                        <uix:link textBinding="DIFFS_TRAIN_SELECT_TABLE@uixWorkspaceObjectBundle"/>
				                        <uix:link textBinding="DIFFS_TRAIN_SHOW_DIFFS@uixWorkspaceObjectBundle"/>				                        
				                    </uix:contents>
				                </uix:train>
				            </uix:location>
                     <uix:pageButtons>
	          	  		<uix:pageButtonBar>
	                  	  <uix:submitButton name="event" value="cancel" textBinding="CANCEL@uixDBObjectBundle@servletRequest" shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
	                      <uix:spacer width="5"/>
                          <uix:switcher childNameBinding="dataExists@objectBean@servletRequest">
		                  	<uix:case name="true">    	
		                          <uix:navigationBar maxValue="3" minValue="1" name="diffsNavigationBar" value="2" destination="/console/database/workspacemgr/workspace" formName="diffWorkspaces" formSubmitted="true" />
		    	    		</uix:case>
						 	<uix:case name="false">    	
		                          <uix:navigationBar maxValue="2" minValue="1" name="diffsNavigationBar" value="2" destination="/console/database/workspacemgr/workspace" formName="diffWorkspaces" formSubmitted="true" />
		    	    		</uix:case>
	                    </uix:switcher>   

                       	</uix:pageButtonBar>
	            	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
