<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>

<%-- Page:        showDiffsSelWks.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: 
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixSDKUIMsgBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
		<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
        <uix:body>
            <db:form name="diffWorkspaces" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/showDiffsSelWks" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
	                   <uix:styledText styleClass="OraInstructionText" textBinding="SHOW_DIFFERENCES_INFO@uixWorkspaceObjectBundle"  />		       
						<uix:header textBinding="DIFFS_SELECT_FIRST_WK_HDR@uixWorkspaceObjectBundle">		       
                          <uix:contents>
                            <uix:tableLayout>
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:styledText styleClass="OraInstructionText" labeledNodeId="selWorkspace" textBinding="NAME_HEADER@uixWorkspaceObjectBundle"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:messageLovField name="selWorkspace" id="selWorkspace" textBinding="workspaceName@objectBean@servletRequest" disabled="true"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout vAlign="top">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText"   textBinding="USE_DATA@uixWorkspaceObjectBundle"/>
                                    <uix:spacer height="10" width="20"/>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:stackLayout>
                                          <uix:contents>
													 <uix:tableLayout>
					                                    <uix:contents>
					                                        <uix:rowLayout>
					                                            <uix:contents>
					                                                <uix:messageRadioButton name="savePointSelOption" value="LATEST" textBinding="CURRENT_DATA@uixWorkspaceObjectBundle" selectedValueBinding="selectedSavepointSelOption@operationsOptions@objectBean@servletRequest" />
					                                            </uix:contents>
					                                        </uix:rowLayout>
					                                        <uix:rowLayout>
					                                            <uix:contents>
					                                                <uix:messageRadioButton name="savePointSelOption" value="SAVEPOINT_OTHER" textBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" selectedValueBinding="selectedSavepointSelOption@operationsOptions@objectBean@servletRequest" />
					                                                <uix:spacer width="10" height="10" />
					                                                <uix:switcher childNameBinding="disableSelectedSavepointLov@objectBean@servletRequest">
												                    	<uix:case name="true">    	
		   						                    			            <uix:messageLovField name="selSavepoint"
																		
searchDescBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" onClick = "preserveCase();setBindSqlParm('selWorkspace');startLov('selSavepoint', 'ListWorkspaceSavepoint')" shortDescBinding="SAVEPOINTS_HEADER@uixWorkspaceObjectBundle"/>  
														        		</uix:case>					
										        		            	<uix:case name="false">    	
		   						                    			            <uix:messageLovField name="selSavepoint"
																		
searchDescBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" onClick = "preserveCase();setBindSqlParm('selWorkspace');startLov('selSavepoint', 'ListWorkspaceSavepoint')" textBinding="selectedSavepoint@operationsOptions@objectBean@servletRequest" shortDescBinding="SAVEPOINTS_HEADER@uixWorkspaceObjectBundle"/>  
														        		</uix:case>																				        		                    								        		
									                                </uix:switcher> 
					                                            </uix:contents>
					                                        </uix:rowLayout>
					                                    </uix:contents>
					                                </uix:tableLayout>
                                          </uix:contents>
                                        </uix:stackLayout>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
						<uix:header textBinding="DIFFS_SELECT_SECOND_WK_HDR@uixWorkspaceObjectBundle">		       
                          <uix:contents>
                            <uix:tableLayout>
                              <uix:contents>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:styledText styleClass="OraInstructionText" textBinding="NAME_HEADER@uixWorkspaceObjectBundle"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:spacer height="10" width="10"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:messageLovField name="workspaceToCompare" searchDescBinding="NAME_HEADER@uixWorkspaceObjectBundle" onClick = "preserveCase();startLov('workspaceToCompare', 'ListWorkspaces')" textBinding="workspaceToCompare@operationsOptions@objectBean@servletRequest" shortDescBinding="WORKSPACES_HEADER@uixWorkspaceObjectBundle"/>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:rowLayout>
                                <uix:rowLayout vAlign="top">
                                 <uix:contents>
                                    <uix:styledText styleClass="OraInstructionText"
                                                textBinding="USE_DATA@uixWorkspaceObjectBundle"/>
                                    <uix:spacer height="10" width="20"/>
                                    <uix:cellFormat>
                                      <uix:contents>
                                        <uix:stackLayout>
                                          <uix:contents>
													 <uix:tableLayout>
					                                    <uix:contents>
					                                        <uix:rowLayout>
					                                            <uix:contents>
					                                                <uix:messageRadioButton name="compareSavepointOption" value="LATEST" textBinding="CURRENT_DATA@uixWorkspaceObjectBundle" selectedValueBinding="workspaceToCompareSavepointSelOption@operationsOptions@objectBean@servletRequest" />
					                                            </uix:contents>
					                                        </uix:rowLayout>
					                                        <uix:rowLayout>
					                                            <uix:contents>
					                                                <uix:messageRadioButton name="compareSavepointOption" value="SAVEPOINT_OTHER" textBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" selectedValueBinding="workspaceToCompareSavepointSelOption@operationsOptions@objectBean@servletRequest"  />
					                                                <uix:spacer width="10" height="10" />
					                                                <uix:switcher childNameBinding="disableWorkspaceToCompareSavepointLov@objectBean@servletRequest">
												                    	<uix:case name="true">    	
		   						                    			            <uix:messageLovField
name="workspaceToCompareSavepoint"  searchDescBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" onClick = "preserveCase();setBindSqlParm('workspaceToCompare');startLov('workspaceToCompareSavepoint', 'ListWorkspaceSavepoint')"  shortDescBinding="SAVEPOINTS_HEADER@uixWorkspaceObjectBundle"/>  
														        		</uix:case>					
										        		            	<uix:case name="false">    	
		   						                    			            <uix:messageLovField
name="workspaceToCompareSavepoint" searchDescBinding="FROM_SAVEPOINT@uixWorkspaceObjectBundle" onClick = "preserveCase();setBindSqlParm('workspaceToCompare');startLov('workspaceToCompareSavepoint', 'ListWorkspaceSavepoint')" textBinding="workspaceToCompareSavepoint@operationsOptions@objectBean@servletRequest" shortDescBinding="SAVEPOINTS_HEADER@uixWorkspaceObjectBundle"/>  
														        		</uix:case>																				        		                    								        		
									                                </uix:switcher>

					                                            </uix:contents>
					                                        </uix:rowLayout>
					                                    </uix:contents>
					                                </uix:tableLayout>
                                          </uix:contents>
                                        </uix:stackLayout>
                                      </uix:contents>
                                    </uix:cellFormat>
                                  </uix:contents>
                                </uix:rowLayout>
                              </uix:contents>
                            </uix:tableLayout>
                          </uix:contents>
                        </uix:header>
                    </uix:contents>
                    <uix:location>
		                <uix:train selectedIndex="0">
		                    <uix:contents>
		                        <uix:link textBinding="DIFFS_TRAIN_SELECT_WKS@uixWorkspaceObjectBundle"/>
		                        <uix:link textBinding="DIFFS_TRAIN_SELECT_TABLE@uixWorkspaceObjectBundle"/>
		                        <uix:link textBinding="DIFFS_TRAIN_SHOW_DIFFS@uixWorkspaceObjectBundle"/>
		                    </uix:contents>
		                </uix:train>
		            </uix:location>
                     <uix:pageButtons>
	          	  		<uix:pageButtonBar>
                          <uix:submitButton name="event" value="cancel" textBinding="CANCEL@uixDBObjectBundle@servletRequest" shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                          <uix:spacer width="5"/>
                          <uix:navigationBar maxValue="3" minValue="1" name="diffsNavigationBar" value="1" destination="/console/database/workspacemgr/workspace" formName="diffWorkspaces" formSubmitted="true" />
                       	</uix:pageButtonBar>
	            	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
