<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>

<%-- Page:        showDiffsShowDetails.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: 
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixSDKUIMsgBundle"  class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="diffWorkspaces" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType">
                <uix:formValue name="pageName" value="/database/workspace/showDiffsShowDetails" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
                         <uix:labeledFieldLayout columns="2" >
						    <uix:messagePrompt promptBinding="DIFFS_SELECT_FIRST_WK_HDR@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />

						    <uix:messagePrompt promptBinding="DIFFS_SELECT_SECOND_WK_HDR@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceToCompare@operationsOptions@objectBean@servletRequest" />

						    <uix:messagePrompt promptBinding="SELECTED_SAVEPOINT@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="selectedSavepoint@operationsOptions@objectBean@servletRequest" />
						    
						    <uix:messagePrompt promptBinding="SELECTED_SAVEPOINT@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceToCompareSavepoint@operationsOptions@objectBean@servletRequest" />
						</uix:labeledFieldLayout>
                        <uix:header textBinding="fullyQualifiedName@selSearchedTable@objectBean@servletRequest">
						    <uix:contents>
						        <uix:tableLayout width="100%">
						            <uix:contents>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:styledText styleClass="OraInstructionText" textBinding="DIFFS_TABLE_DETAILS_INFO@uixWorkspaceObjectBundle" />
						                    </uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:spacer height="10" width="10" />
						                    </uix:contents>
						                </uix:rowLayout>
<%--	  			                   <uix:rowLayout width="100%">
						                    <uix:contents>
						                    <uix:dataScope currentDataBinding="conflictingTableDetailsbean@servletRequest">
						                   		 <uix:include nodeBinding="conflictingTableDetailsbean@servletRequest"/>
						                    </uix:dataScope>
						                    </uix:contents>
						                </uix:rowLayout> --%>
						                
										<uix:rowLayout width="100%">
						                    <uix:contents>
						                    <%
							                    boolean isDynaTableNotNull = false;
							                    Object  getIsDynaTableNotNull = request.getAttribute("isDynaTableNotNull");
							                    if (getIsDynaTableNotNull != null)
							                    	isDynaTableNotNull = ((Boolean)getIsDynaTableNotNull).booleanValue();					                    	
							            
												if ( isDynaTableNotNull )
												{
											%> 
												<oem:table name="tablesDetailsUITable" beanKey="dynaOEMTableDS"
												summaryBinding="SHOW_DETAILS@uixWorkspaceObjectBundle"
					             						blockSize="10"  formSubmitted="true"
		            			 					dataSourceProp="dynaTableUI" 
													alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
													width="100%" copyParams="target,type">
													 <uix:tableSelection>
									                       <uix:singleSelection shortDescBinding="SHOW_DETAILS@uixWorkspaceObjectBundle" selectedIndexBinding="selectedIndex@dynaOEMTableDS@servletRequest" >
									                         <uix:contents>
																<uix:switcher childNameBinding="dataExists@objectBean@servletRequest">
											                  		<uix:case name="true">    	
																		    <uix:submitButton textBinding="SHOW_DETAILS@uixWorkspaceObjectBundle" 
															                      shortDescBinding="SHOW_DETAILS@uixWorkspaceObjectBundle"
															                      name="event" 
															                      value="SHOW_DETAILS"/>
												    	    		</uix:case>
											                    </uix:switcher>   						                      
									                         </uix:contents>
									                       </uix:singleSelection>
	 								                    </uix:tableSelection>		
													</oem:table>	
													<%
													}
													%>
											</uix:contents>
						                </uix:rowLayout>
						                <uix:rowLayout>
						                    <uix:contents>
						                        <uix:spacer height="10" width="10" />
						                    </uix:contents>
						                </uix:rowLayout>
						            </uix:contents>
						        </uix:tableLayout>
				
		                        <uix:header textBinding="SEL_ROW_DETAILS@uixWorkspaceObjectBundle" renderedBinding="isDynaTableNotNull@servletRequest">
								    <uix:contents>
								        <uix:tableLayout width="100%">
								            <uix:contents>
												<uix:rowLayout>
								                    <uix:contents>
														<uix:table name="rowDetailsUIXTableDS"
														alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
														summaryBinding="SEL_ROW_DETAILS@uixWorkspaceObjectBundle"
														formSubmitted="true" 
														width="80%" 
														tableDataBinding="rowData@rowDetailsUIXTableDS@servletRequest"
														blockSizeBinding="blockSize@rowDetailsUIXTableDS@servletRequest" 
											            maxValueBinding="numRows@rowDetailsUIXTableDS@servletRequest"
								            			valueBinding="startIndex@rowDetailsUIXTableDS@servletRequest" >
														    <uix:tableFormat tableBanding="rowBanding" />
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="COLUMN_NAME_HDR@uixWorkspaceObjectBundle"/>
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="COLUMN_NAME_HDR" />
														    </uix:column>
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="BASE_WORKSPACE_HDR@uixWorkspaceObjectBundle"/>
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="BASE_FIELD" />
														    </uix:column>
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="work1Name@rowDetailsUIXTableDS@servletRequest"  />
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="WORKSPACE1_FIELD" />
														    </uix:column>
														    <uix:column>
														        <uix:columnHeader>
														            <uix:sortableHeader textBinding="work2Name@rowDetailsUIXTableDS@servletRequest" />
														        </uix:columnHeader>
														        <uix:columnFormat columnDataFormat="textFormat" width="25%"/>
														        <uix:text textBinding="WORKSPACE2_FIELD" />
														    </uix:column>
														</uix:table>
													</uix:contents>
								                </uix:rowLayout>
										      <%-- tip --%>
										      <uix:rowLayout>
													<uix:contents>
												        <uix:tip textBinding="DETAILS_ACRONYM@uixWorkspaceObjectBundle"/>
													</uix:contents>
										      </uix:rowLayout>
								            </uix:contents>
								        </uix:tableLayout>
								    </uix:contents>
								</uix:header>
						    </uix:contents>
						</uix:header>
                    </uix:contents>
                     <uix:location>
		                <uix:train selectedIndex="2">
		                    <uix:contents>
		                        <uix:link textBinding="DIFFS_TRAIN_SELECT_WKS@uixWorkspaceObjectBundle"/>
		                        <uix:link textBinding="DIFFS_TRAIN_SELECT_TABLE@uixWorkspaceObjectBundle"/>
		                        <uix:link textBinding="DIFFS_TRAIN_SHOW_DIFFS@uixWorkspaceObjectBundle"/>
		                    </uix:contents>
		                </uix:train>
		            </uix:location>
                     <uix:pageButtons>
	          	  		<uix:pageButtonBar>
                          <uix:navigationBar maxValue="3" minValue="1" name="diffsNavigationBar" value="3" destination="/console/database/workspacemgr/workspace" formName="diffWorkspaces" formSubmitted="true" />
						  <uix:spacer width="5"/>                          
                          <uix:submitButton name="event" value="cancel" textBinding="FINISH@uixDBMsgBundle" shortDescBinding="FINISH@uixDBMsgBundle"/>
                       	</uix:pageButtonBar>
	            	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
