<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        systemParameters.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: This is the central screen to manage System parameters functionality.
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="systemParameters" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL" >
                <uix:formValue name="pageName" value="/database/workspace/systemParameters" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:contents>
	                       <uix:tableLayout width="100%" cellSpacing="5">
						    <uix:contents>
						        <uix:rowLayout >
						            <uix:contents>
					                    <uix:styledText styleClass="OraInstructionText" textBinding="WORKSPACE_SYSTEM_PARAMETERS_INFO@uixWorkspaceObjectBundle"  />
						            </uix:contents>
						        </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
		                                <uix:table name="systemParametersListTable"
										summaryBinding="WORKSPACE_SYSTEM_PARAMETERS_INFO@uixWorkspaceObjectBundle" 
										alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
										formSubmitted="true" 
										width="100%" 
										tableDataBinding="rowData@sysParambean@servletRequest"
										blockSizeBinding="blockSize@sysParambean@servletRequest" 
							            maxValueBinding="numRows@sysParambean@servletRequest"
				            			valueBinding="startIndex@sysParambean@servletRequest" >
										    <uix:tableFormat tableBanding="rowBanding" />
										    <uix:column>
										        <uix:columnHeader>
										            <uix:sortableHeader textBinding="SYS_PARAMETER_TXT@uixWorkspaceObjectBundle" />
										        </uix:columnHeader>
										        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
										        <uix:text textBinding="SYS_PARAMETER_TXT" />
										    </uix:column>
										    <uix:column>
										        <uix:columnHeader>
										            <uix:sortableHeader textBinding="SYS_PARAMETER_VALUE_TXT@uixWorkspaceObjectBundle"/>
										        </uix:columnHeader>
										        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
										        <uix:messageChoice name="SYS_PARAMETER_VALUE_TXT"
											
id="SYS_PARAMETER_VALUE_TXT" selectedValueBinding="SYS_PARAMETER_VALUE_TXT">
												    <uix:contents childDataBinding="sysParamOptions">
                 										<uix:option textBinding="textKey" valueBinding="valueKey"/>
						       		                </uix:contents>
					       					   </uix:messageChoice>
										    </uix:column>
										</uix:table>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                    </uix:contents>
	                <uix:pageButtons>
		          	  		<uix:pageButtonBar>
		                   	   <jsp:include page="workspaceButtonInclude.jsp" />
		                       <uix:ref refID="savepointInclude" />
		                  	</uix:pageButtonBar>
	              	</uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
